/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.ne;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.format.mz.DOSHeader;
import ghidra.app.util.bin.format.ne.InvalidWindowsHeaderException;
import ghidra.app.util.bin.format.ne.WindowsHeader;
import ghidra.program.model.address.SegmentedAddress;
import java.io.IOException;

public class NewExecutable {
    private BinaryReader reader;
    private DOSHeader dosHeader;
    private WindowsHeader winHeader;

    public NewExecutable(ByteProvider bp, SegmentedAddress baseAddr) throws IOException {
        this.reader = new BinaryReader(bp, true);
        this.dosHeader = new DOSHeader(this.reader);
        if (this.dosHeader.isDosSignature()) {
            try {
                this.winHeader = new WindowsHeader(this.reader, baseAddr, (short)this.dosHeader.e_lfanew());
            }
            catch (InvalidWindowsHeaderException invalidWindowsHeaderException) {
                // empty catch block
            }
        }
    }

    public BinaryReader getBinaryReader() {
        return this.reader;
    }

    public DOSHeader getDOSHeader() {
        return this.dosHeader;
    }

    public WindowsHeader getWindowsHeader() {
        return this.winHeader;
    }
}

