/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.udif;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import org.catacombae.io.ReadableFileStream;
import org.catacombae.io.ReadableRandomAccessStream;
import org.catacombae.io.RuntimeIOException;
import org.catacombae.udif.Koly;
import org.catacombae.udif.Plist;

public class UDIFFileView {
    private ReadableRandomAccessStream dmgRaf;

    public UDIFFileView(File file) {
        try {
            this.dmgRaf = new ReadableFileStream(new RandomAccessFile(file, "r"));
        }
        catch (IOException ioe) {
            throw new RuntimeIOException(ioe);
        }
    }

    public UDIFFileView(ReadableRandomAccessStream dmgRaf) {
        this.dmgRaf = dmgRaf;
    }

    public byte[] getPlistData() throws RuntimeIOException {
        Koly koly = this.getKoly();
        byte[] plistData = new byte[(int)koly.getPlistSize()];
        this.dmgRaf.seek(koly.getPlistBegin1());
        if (this.dmgRaf.read(plistData) == plistData.length) {
            return plistData;
        }
        throw new RuntimeException("Could not read the entire region of data containing the Plist");
    }

    public Plist getPlist() throws RuntimeIOException {
        return new Plist(this.getPlistData());
    }

    public Koly getKoly() throws RuntimeIOException {
        this.dmgRaf.seek(this.dmgRaf.length() - 512L);
        byte[] kolyData = new byte[512];
        this.dmgRaf.read(kolyData);
        return new Koly(kolyData, 0);
    }

    public void close() throws RuntimeIOException {
        this.dmgRaf.close();
    }
}

