/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.database.spatial.hyper;

import ghidra.util.database.spatial.hyper.Dimension;
import ghidra.util.database.spatial.hyper.HyperBox;
import ghidra.util.database.spatial.hyper.HyperPoint;

public interface ULongDimension<P extends HyperPoint, B extends HyperBox<P, B>>
extends Dimension<Long, P, B> {
    @Override
    default public int compare(Long a, Long b) {
        return Long.compareUnsigned(a, b);
    }

    @Override
    default public double distance(Long a, Long b) {
        return a - b;
    }

    @Override
    default public Long mid(Long a, Long b) {
        return a + Long.divideUnsigned(b - a, 2L);
    }

    @Override
    default public Long absoluteMin() {
        return 0L;
    }

    @Override
    default public Long absoluteMax() {
        return -1L;
    }
}

