/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.services.Analyzer;
import ghidra.framework.options.Options;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.util.Set;
import pdb.PdbPlugin;
import pdb.symbolserver.FindOption;
import pdb.symbolserver.SymbolFileInfo;

public class PdbAnalyzerCommon {
    static final String OPTION_DESCRIPTION_SEARCH_UNTRUSTED_LOCATIONS = "If checked, allow searching untrusted symbol servers for PDB files.";
    static final String OPTION_NAME_SEARCH_UNTRUSTED_LOCATIONS = "Search untrusted symbol servers";
    static final String OPTION_DESCRIPTION_PDB_FILE = "Path to a manually chosen PDB file.";
    static final String OPTION_NAME_PDB_FILE = "PDB File";

    public static boolean canAnalyzeProgram(Program program) {
        String executableFormat = program.getExecutableFormat();
        return executableFormat != null && executableFormat.indexOf("Portable Executable (PE)") != -1;
    }

    static void setPdbFileOption(String analyzerName, Program program, File pdbFile) {
        Options options = program.getOptions("Analyzers");
        options.setFile(analyzerName + ".PDB File", pdbFile);
    }

    static void setAllowUntrustedOption(String analyzerName, Program program, boolean allowUntrusted) {
        Options options = program.getOptions("Analyzers");
        options.setBoolean(analyzerName + ".Search untrusted symbol servers", allowUntrusted);
    }

    static File findPdb(Analyzer pdbAnalyzer, Program program, boolean allowRemote, TaskMonitor monitor) {
        String pdbFileOptionName;
        File pdbFile;
        SymbolFileInfo symbolFileInfo = SymbolFileInfo.fromProgramInfo(program);
        if (symbolFileInfo == null) {
            Msg.info((Object)pdbAnalyzer, (Object)"Skipping PDB processing: missing PDB information in program metadata");
            return null;
        }
        Options options = program.getOptions("Analyzers");
        File file = pdbFile = options.contains(pdbFileOptionName = pdbAnalyzer.getName() + ".PDB File") ? options.getFile(pdbFileOptionName, null) : null;
        if (pdbFile == null) {
            Set<FindOption> findOpts = allowRemote ? FindOption.of(FindOption.ALLOW_UNTRUSTED) : FindOption.NO_OPTIONS;
            pdbFile = PdbPlugin.findPdb(program, findOpts, monitor);
        }
        if (pdbFile == null) {
            Msg.info((Object)pdbAnalyzer, (Object)"Skipping PDB processing: failed to locate PDB file in configured locations");
            if (SystemUtilities.isInHeadlessMode()) {
                Msg.info((Object)pdbAnalyzer, (Object)"Use a script to set the PDB file location. I.e.,\n    PdbAnalyzer.setPdbFileOption(currentProgram, new File(\"/path/to/pdb/file.pdb\")); or\n    PdbUniversalAnalyzer.setPdbFileOption(currentProgram, new File(\"/path/to/pdb/file.pdb\"));\nOr set the symbol server search configuration using:    PdbPlugin.saveSymbolServerServiceConfig(...);\n This must be done using a pre-script (prior to analysis).");
            } else {
                Msg.info((Object)pdbAnalyzer, (Object)"You may set the PDB \"Symbol Server Config\"\n using \"Edit->Symbol Server Config\" prior to analysis.\nIt is important that a PDB is used during initial analysis \nif available.");
            }
        } else {
            Msg.info((Object)pdbAnalyzer, (Object)("PDB analyzer parsing file: " + String.valueOf(pdbFile)));
            if (!pdbFile.isFile()) {
                Msg.error((Object)pdbAnalyzer, (Object)("Skipping PDB processing: specified file does not exist or is not readable: " + String.valueOf(pdbFile)));
                return null;
            }
        }
        return pdbFile;
    }
}

