/*
 * Decompiled with CFR 0.152.
 */
package org.rzo.netty.ahessian.rpc.message;

import com.caucho.hessian4.io.AbstractSerializerFactory;
import com.caucho.hessian4.io.HessianProtocolException;
import io.netty.channel.ChannelHandlerContext;
import java.io.InputStream;
import org.rzo.netty.ahessian.Constants;
import org.rzo.netty.ahessian.io.InputStreamConsumer;
import org.rzo.netty.ahessian.io.InputStreamHandler;
import org.rzo.netty.ahessian.rpc.callback.CallbackReplyMessage;
import org.rzo.netty.ahessian.rpc.client.HessianProxyFactory;
import org.rzo.netty.ahessian.rpc.io.Hessian2Input;
import org.rzo.netty.ahessian.rpc.message.HessianRPCReplyMessage;

public class HessianRPCReplyDecoder
implements InputStreamConsumer,
Constants {
    HessianProxyFactory _factory;
    volatile Hessian2Input in = null;
    volatile AbstractSerializerFactory _serializerFactory;

    public HessianRPCReplyDecoder(HessianProxyFactory factory) {
        this._factory = factory;
    }

    public HessianRPCReplyDecoder(HessianProxyFactory factory, AbstractSerializerFactory serializerFactory) {
        this._factory = factory;
        this._serializerFactory = serializerFactory;
    }

    @Override
    public void consume(ChannelHandlerContext ctx, InputStream inx) {
        while (ctx.channel().isActive() && !this.isBufferEmpty()) {
            HessianRPCReplyMessage m = this.parseReply(this.in);
            if (m != null) {
                ctx.fireChannelRead((Object)m);
            }
            this.in.resetReferences();
            if (!this.isBufferEmpty()) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    HessianRPCReplyMessage parseReply(Hessian2Input in) {
        Object value = null;
        Object fault = null;
        Long callbackId = null;
        Long callbackCallId = null;
        String callbackMethod = null;
        Object[] callbackArgs = null;
        Boolean callbackDone = null;
        Boolean completed = null;
        Integer group = null;
        Long callId = null;
        try {
            HessianRPCReplyMessage result;
            int code = in.read();
            if (code != 72) {
                throw new HessianProtocolException("H expected got 0x" + Integer.toHexString(code & 0xFF) + " (" + (char)code + ")");
            }
            in.read();
            in.read();
            in.readEnvelope();
            String h = in.readString();
            if (!"H".equals(h)) {
                throw new HessianProtocolException("Missing headers");
            }
            int l = in.readInt();
            block17: for (int i = 0; i < l; ++i) {
                Integer key = in.readInt();
                Object hvalue = in.readObject();
                switch (key) {
                    case 3: {
                        callbackId = (Long)hvalue;
                        continue block17;
                    }
                    case 9: {
                        callbackCallId = (Long)hvalue;
                        continue block17;
                    }
                    case 4: {
                        callbackMethod = (String)hvalue;
                        continue block17;
                    }
                    case 5: {
                        callbackArgs = (Object[])hvalue;
                        continue block17;
                    }
                    case 6: {
                        callbackDone = (Boolean)hvalue;
                        continue block17;
                    }
                    case 7: {
                        completed = (Boolean)hvalue;
                        continue block17;
                    }
                    case 0: {
                        group = (Integer)hvalue;
                        continue block17;
                    }
                    case 1: {
                        callId = (Long)hvalue;
                        continue block17;
                    }
                }
            }
            code = in.read();
            if (code != 72) {
                throw new HessianProtocolException("'" + (char)code + "' is an unknown code");
            }
            in.read();
            in.read();
            Object obj = null;
            try {
                obj = in.readReply(null);
            }
            catch (Throwable e) {
                HessianRPCReplyMessage result2 = new HessianRPCReplyMessage(null, e, null);
                result2.setCallId(callId);
                result2.setGroup(group);
                result2.setCallbackId(callbackId);
                HessianRPCReplyMessage hessianRPCReplyMessage = result2;
                return hessianRPCReplyMessage;
            }
            finally {
                in.completeReply();
                in.completeEnvelope();
                in.resetReferences();
            }
            if (callbackId != null) {
                result = new CallbackReplyMessage(callbackMethod, callbackArgs, null, null);
                result.setCallbackDone(callbackDone);
                result.setCallbackId(callbackId);
                result.setCallId(callId);
                result.setCompleted(completed);
                result.setGroup(group);
                result.setCallbackCallId(callbackCallId);
                return result;
            }
            result = new HessianRPCReplyMessage(obj, null, null);
            result.setCallId(callId);
            result.setCompleted(completed);
            result.setGroup(group);
            return result;
        }
        catch (Throwable ex) {
            if (ex.getMessage() != null && ex.getMessage().startsWith("H expected got 0x0")) {
                Constants.ahessianLogger.info("received Ping");
            } else {
                Constants.ahessianLogger.warn("", ex);
            }
            if (callId == null) return null;
            HessianRPCReplyMessage result = new HessianRPCReplyMessage(null, ex, null);
            result.setCallId(callId);
            result.setGroup(group);
            result.setCallbackId(callbackId);
            return result;
        }
    }

    @Override
    public boolean isBufferEmpty() {
        return this.in != null && this.in.bufferEmpty();
    }

    @Override
    public void setContext(ChannelHandlerContext ctx) {
        if (this.in == null) {
            this.in = new Hessian2Input(InputStreamHandler.getInputStream(ctx));
            if (this._serializerFactory != null) {
                this.in.getSerializerFactory().addFactory(this._serializerFactory);
            }
        }
    }
}

