/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.prof;

import ghidra.app.util.bin.ByteProvider;
import java.util.Arrays;

public final class ProfileConstants {
    public static final byte[] kProfileMagic = new byte[]{112, 114, 111, 0};
    public static final int kProfileMagicLength = kProfileMagic.length;
    public static final byte[] kProfileVersion_008 = new byte[]{48, 48, 56, 0};
    public static final byte[] kProfileVersion_009 = new byte[]{48, 48, 57, 0};
    public static final byte[] kProfileVersion_010 = new byte[]{48, 49, 48, 0};
    public static final byte[] kProfileVersionForBootImage_012 = new byte[]{48, 49, 50, 0};
    public static final String kDexMetadataProfileEntry = "primary.prof";
    public static final byte[] kProfileVersionWithCounters = new byte[]{53, 48, 48, 0};

    public static final String toString(byte[] bytes) {
        return new String(bytes).trim();
    }

    public static boolean isProfile(ByteProvider provider) {
        try {
            byte[] versionBytes;
            byte[] magicBytes = provider.readBytes(0L, (long)kProfileMagicLength);
            if (Arrays.equals(magicBytes, kProfileMagic) && Arrays.equals(versionBytes = provider.readBytes((long)kProfileMagicLength, (long)kProfileVersion_010.length), kProfileVersion_010)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

