/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.main.datatable;

import ghidra.framework.data.LinkHandler;
import ghidra.framework.main.BrokenLinkIcon;
import ghidra.framework.main.datatable.DomainFileType;
import ghidra.framework.main.datatable.ProjectDataTableModel;
import ghidra.framework.main.datatree.DomainFileNode;
import ghidra.framework.model.DomainFile;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;

public class DomainFileInfo {
    private DomainFile domainFile;
    private ProjectDataTableModel model;
    private int modCount;
    private String name;
    private String path;
    private Map<String, String> metadata;
    private Date modificationDate;
    private DomainFileType domainFileType;
    private Boolean isBrokenLink;
    private String toolTipText;

    DomainFileInfo(DomainFile domainFile, ProjectDataTableModel model) {
        this.domainFile = domainFile;
        this.model = model;
    }

    private String computeName() {
        Object displayName = this.domainFile.getName();
        if (this.domainFile.isHijacked()) {
            displayName = (String)displayName + " (hijacked)";
        } else if (this.domainFile.isVersioned()) {
            int versionNumber = this.domainFile.getVersion();
            Object versionStr = "" + versionNumber;
            if (versionNumber < 0) {
                versionStr = "?";
            }
            if (this.domainFile.isCheckedOut()) {
                int latestVersionNumber = this.domainFile.getLatestVersion();
                Object latestVersionStr = "" + latestVersionNumber;
                if (latestVersionNumber <= 0) {
                    latestVersionStr = "?";
                }
                displayName = (String)displayName + " (" + (String)versionStr + " of " + (String)latestVersionStr + ")";
                if (this.domainFile.modifiedSinceCheckout()) {
                    displayName = (String)displayName + "*";
                }
            } else {
                displayName = (String)displayName + " (" + (String)versionStr + ")";
            }
        }
        return displayName;
    }

    public synchronized String getDisplayName() {
        this.checkModelModCount();
        if (this.name == null) {
            this.name = this.computeName();
        }
        return this.name;
    }

    public synchronized String getPath() {
        this.checkModelModCount();
        if (this.path == null) {
            this.path = this.domainFile.getParent().getPathname();
        }
        return this.path;
    }

    public synchronized DomainFileType getDomainFileType() {
        this.checkModelModCount();
        if (this.domainFileType == null) {
            this.checkStatus();
            String contentType = this.domainFile.getContentType();
            Icon icon = this.domainFile.getIcon(false);
            if (this.isBrokenLink.booleanValue()) {
                icon = new BrokenLinkIcon(icon);
            }
            boolean isVersioned = this.domainFile.isVersioned();
            this.domainFileType = new DomainFileType(contentType, icon, isVersioned);
        }
        return this.domainFileType;
    }

    public synchronized Date getModificationDate() {
        this.checkModelModCount();
        if (this.modificationDate == null) {
            this.modificationDate = this.getLastModifiedTime();
        }
        return this.modificationDate;
    }

    private Date getLastModifiedTime() {
        long lastModified = this.domainFile.getLastModifiedTime();
        if (lastModified != 0L) {
            return new Date(lastModified);
        }
        return new Date();
    }

    private synchronized Map<String, String> getMetadata() {
        this.checkModelModCount();
        if (this.metadata == null) {
            this.metadata = this.domainFile.getMetadata();
            if (this.metadata == null) {
                this.metadata = new HashMap<String, String>();
            }
        }
        return this.metadata;
    }

    public DomainFile getDomainFile() {
        return this.domainFile;
    }

    public synchronized void clearMetaCache() {
        this.metadata = null;
        this.modificationDate = null;
        this.refresh();
    }

    public synchronized void refresh() {
        this.domainFileType = null;
        this.isBrokenLink = null;
        this.toolTipText = null;
        this.name = null;
        this.path = null;
    }

    public String getMetaDataValue(String key) {
        Map<String, String> meta = this.getMetadata();
        return meta.get(key);
    }

    public String getName() {
        return this.domainFile.getName();
    }

    private void checkModelModCount() {
        int modelModCount = this.model.getModCount();
        if (modelModCount != this.modCount) {
            this.refresh();
            this.modCount = modelModCount;
        }
    }

    private synchronized void checkStatus() {
        this.checkModelModCount();
        if (this.isBrokenLink == null) {
            this.isBrokenLink = false;
            ArrayList linkErrors = null;
            if (this.domainFile.isLink()) {
                ArrayList errors = new ArrayList();
                LinkHandler.LinkStatus linkStatus = LinkHandler.getLinkFileStatus(this.domainFile, msg -> errors.add(msg));
                this.isBrokenLink = linkStatus == LinkHandler.LinkStatus.BROKEN;
                if (this.isBrokenLink.booleanValue()) {
                    linkErrors = errors;
                }
            }
            this.toolTipText = DomainFileNode.getToolTipText(this.domainFile, linkErrors);
        }
    }

    public String getToolTip() {
        this.checkStatus();
        return this.toolTipText;
    }
}

