/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang.protorules;

import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.lang.ParamListStandard;
import ghidra.program.model.lang.ParameterPieces;
import ghidra.program.model.lang.PrototypePieces;
import ghidra.program.model.lang.protorules.AssignAction;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.util.exception.InvalidInputException;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlParseException;
import ghidra.xml.XmlPullParser;
import java.io.IOException;

public class ConvertToPointer
extends AssignAction {
    private AddressSpace space;

    public ConvertToPointer(ParamListStandard res) {
        super(res);
        this.space = res.getSpacebase();
    }

    @Override
    public AssignAction clone(ParamListStandard newResource) throws InvalidInputException {
        return new ConvertToPointer(newResource);
    }

    @Override
    public boolean isEquivalent(AssignAction op) {
        if (this.getClass() != op.getClass()) {
            return false;
        }
        ConvertToPointer otherAction = (ConvertToPointer)op;
        if (this.space == null && otherAction.space == null) {
            return true;
        }
        if (this.space == null || otherAction.space == null) {
            return false;
        }
        return this.space.equals(otherAction.space);
    }

    @Override
    public int assignAddress(DataType dt, PrototypePieces proto, int pos, DataTypeManager dtManager, int[] status, ParameterPieces res) {
        int pointersize = this.space != null ? this.space.getPointerSize() : -1;
        Pointer pointertp = dtManager.getPointer(dt, pointersize);
        int responseCode = this.resource.assignAddress(pointertp, proto, pos, dtManager, status, res);
        res.isIndirect = true;
        return responseCode;
    }

    @Override
    public void encode(Encoder encoder) throws IOException {
        encoder.openElement(ElementId.ELEM_CONVERT_TO_PTR);
        encoder.closeElement(ElementId.ELEM_CONVERT_TO_PTR);
    }

    @Override
    public void restoreXml(XmlPullParser parser) throws XmlParseException {
        XmlElement elem = parser.start(new String[]{ElementId.ELEM_CONVERT_TO_PTR.name()});
        parser.end(elem);
    }
}

