/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.go.dialog;

import docking.DialogComponentProvider;
import docking.DockingWindowManager;
import docking.widgets.MultiLineLabel;
import docking.widgets.OptionDialog;
import docking.widgets.label.GIconLabel;
import ghidra.app.plugin.core.go.exception.StopWaitingException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;

public abstract class GhidraGoWaitDialog
extends DialogComponentProvider {
    public static final int WAIT = 0;
    public static final int DO_NOT_WAIT = 1;
    protected int actionID = 1;
    protected boolean answered = false;

    public GhidraGoWaitDialog(String title, String msgText, boolean modal) {
        super(title, modal);
        this.addWorkPanel(this.buildMainPanel(msgText));
        JButton waitButton = new JButton("Wait");
        waitButton.getAccessibleContext().setAccessibleName("Wait");
        waitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GhidraGoWaitDialog.this.actionID = 0;
                GhidraGoWaitDialog.this.answered = true;
                GhidraGoWaitDialog.this.close();
            }
        });
        this.addButton(waitButton);
        JButton noWaitButton = new JButton("No");
        noWaitButton.getAccessibleContext().setAccessibleName("No Wait");
        noWaitButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GhidraGoWaitDialog.this.actionID = 1;
                GhidraGoWaitDialog.this.answered = true;
                GhidraGoWaitDialog.this.close();
            }
        });
        this.addButton(noWaitButton);
    }

    public void showDialog() throws StopWaitingException {
        this.answered = false;
        if (!this.isShowing()) {
            DockingWindowManager.showDialog(null, (DialogComponentProvider)this);
        }
        if (this.answered && this.actionID == 1) {
            throw new StopWaitingException();
        }
    }

    public boolean isAnsweredNo() {
        return this.answered && this.actionID == 1;
    }

    public void reset() {
        this.answered = false;
        this.actionID = 0;
        this.close();
    }

    protected JPanel buildMainPanel(String msgTextString) {
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(new BorderLayout());
        innerPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        JPanel msgPanel = new JPanel(new BorderLayout());
        msgPanel.getAccessibleContext().setAccessibleName("Message");
        msgPanel.add((Component)new GIconLabel(OptionDialog.getIconForMessageType((int)2)), "West");
        MultiLineLabel msgText = new MultiLineLabel(msgTextString);
        msgText.getAccessibleContext().setAccessibleName("Message Text");
        msgText.setMaximumSize(msgText.getPreferredSize());
        msgPanel.add((Component)msgText, "Center");
        innerPanel.add((Component)msgPanel, "Center");
        innerPanel.getAccessibleContext().setAccessibleName("Ghidra Go Wait");
        return innerPanel;
    }
}

