/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.oldfunction;

import db.DBHandle;
import db.DBRecord;
import db.Field;
import db.LongField;
import db.Schema;
import db.StringField;
import db.Table;
import ghidra.program.database.map.AddressMap;
import ghidra.program.database.oldfunction.OldRegisterVariableDBAdapter;
import ghidra.util.exception.VersionException;
import java.io.IOException;

class OldRegisterVariableDBAdapterV0
extends OldRegisterVariableDBAdapter {
    static final int SCHEMA_VERSION = 0;
    static final int V0_REG_VAR_FUNCTION_KEY_COL = 0;
    static final int V0_REG_VAR_REGNAME_COL = 1;
    static final int V0_REG_VAR_DATA_TYPE_ID_COL = 2;
    static final int V0_REG_VAR_NAME_COL = 3;
    static final int V0_REG_VAR_COMMENT_COL = 4;
    static final String REG_PARMS_TABLE_NAME = "Register Parameters";
    static final Schema V0_REG_PARAMS_SCHEMA = new Schema(0, "Key", new Field[]{LongField.INSTANCE, StringField.INSTANCE, LongField.INSTANCE, StringField.INSTANCE, StringField.INSTANCE}, new String[]{"Function ID", "Register", "DataType ID", "Name", "Comment"});
    private Table table;

    OldRegisterVariableDBAdapterV0(DBHandle dbHandle, AddressMap addrMap) throws VersionException {
        this.table = dbHandle.getTable(REG_PARMS_TABLE_NAME);
        if (this.table == null || this.table.getSchema().getVersion() != 0) {
            throw new VersionException(false);
        }
    }

    @Override
    public DBRecord getRegisterVariableRecord(long key) throws IOException {
        return this.table.getRecord(key);
    }

    @Override
    public Field[] getRegisterVariableKeys(long functionKey) throws IOException {
        return this.table.findRecords((Field)new LongField(functionKey), 0);
    }

    @Override
    void deleteTable(DBHandle handle) throws IOException {
        handle.deleteTable(REG_PARMS_TABLE_NAME);
    }

    @Override
    int getRecordCount() {
        return this.table.getRecordCount();
    }
}

