/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database.sourcemap;

import db.BinaryField;
import db.ByteField;
import db.DBHandle;
import db.DBListener;
import db.DBRecord;
import db.Field;
import db.RecordIterator;
import db.Schema;
import db.StringField;
import db.Table;
import ghidra.framework.data.OpenMode;
import ghidra.program.database.sourcemap.SourceFile;
import ghidra.program.database.sourcemap.SourceFileAdapter;
import ghidra.program.database.util.EmptyRecordIterator;
import ghidra.util.exception.VersionException;
import java.io.IOException;
import java.util.Arrays;

class SourceFileAdapterV0
extends SourceFileAdapter
implements DBListener {
    static final int SCHEMA_VERSION = 0;
    static final int V0_PATH_COL = 0;
    static final int V0_ID_TYPE_COL = 1;
    static final int V0_ID_COL = 2;
    private static final Schema V0_SCHEMA = new Schema(0, "ID", new Field[]{StringField.INSTANCE, ByteField.INSTANCE, BinaryField.INSTANCE}, new String[]{"Path", "IdType", "Identifier"}, new int[]{0});
    private Table table;
    private final DBHandle dbHandle;
    private static final int[] INDEXED_COLUMNS = new int[]{0};

    SourceFileAdapterV0(DBHandle dbHandle, OpenMode openMode) throws VersionException {
        this.dbHandle = dbHandle;
        this.dbHandle.addListener((DBListener)this);
        if (!openMode.equals((Object)OpenMode.CREATE)) {
            this.table = dbHandle.getTable("SourceFiles");
            if (this.table == null) {
                return;
            }
            int version = this.table.getSchema().getVersion();
            if (version != 0) {
                throw new VersionException(2, false);
            }
        }
    }

    public void dbRestored(DBHandle dbh) {
        this.table = dbh.getTable("SourceFiles");
    }

    public void dbClosed(DBHandle dbh) {
    }

    public void tableDeleted(DBHandle dbh, Table deletedTable) {
    }

    public void tableAdded(DBHandle dbh, Table addedTable) {
    }

    @Override
    RecordIterator getRecords() throws IOException {
        if (this.table == null) {
            return new EmptyRecordIterator();
        }
        return this.table.iterator();
    }

    @Override
    DBRecord getRecord(long id) throws IOException {
        if (this.table == null) {
            return null;
        }
        return this.table.getRecord(id);
    }

    @Override
    DBRecord getRecord(SourceFile sourceFile) throws IOException {
        if (this.table == null) {
            return null;
        }
        StringField field = new StringField(sourceFile.getPath());
        RecordIterator iter = this.table.indexIterator(0, (Field)field, (Field)field, true);
        while (iter.hasNext()) {
            DBRecord rec = iter.next();
            if (rec.getByteValue(1) != sourceFile.getIdType().getIndex() || !Arrays.equals(sourceFile.getIdentifier(), rec.getBinaryData(2))) continue;
            return rec;
        }
        return null;
    }

    @Override
    DBRecord createSourceFileRecord(SourceFile sourceFile) throws IOException {
        DBRecord rec = this.getRecord(sourceFile);
        if (rec == null) {
            rec = V0_SCHEMA.createRecord(this.getTable().getKey());
            rec.setString(0, sourceFile.getPath());
            rec.setByteValue(1, sourceFile.getIdType().getIndex());
            rec.setBinaryData(2, sourceFile.getIdentifier());
            this.getTable().putRecord(rec);
        }
        return rec;
    }

    @Override
    boolean removeSourceFileRecord(long id) throws IOException {
        if (this.table != null) {
            return this.table.deleteRecord(id);
        }
        return false;
    }

    private Table getTable() throws IOException {
        if (this.table == null) {
            this.table = this.dbHandle.createTable("SourceFiles", V0_SCHEMA, INDEXED_COLUMNS);
        }
        return this.table;
    }
}

