/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.framework.PluggableServiceRegistry;
import ghidra.program.model.lang.CompilerSpecID;
import ghidra.program.model.lang.CompilerSpecNotFoundException;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.LanguageCompilerSpecPair;
import ghidra.program.model.lang.LanguageID;
import ghidra.program.model.lang.LanguageNotFoundException;
import ghidra.program.util.DefaultLanguageService;
import ghidra.util.Msg;

public class OldLanguageMappingService {
    public static LanguageCompilerSpecPair lookupMagicString(String magicString, boolean languageReplacementOK) {
        OldLanguageMappingService factory = (OldLanguageMappingService)PluggableServiceRegistry.getPluggableService(OldLanguageMappingService.class);
        return factory.doLookupMagicString(magicString, languageReplacementOK);
    }

    protected LanguageCompilerSpecPair doLookupMagicString(String magicString, boolean languageReplacementOK) {
        return null;
    }

    protected static LanguageCompilerSpecPair validatePair(LanguageCompilerSpecPair pair) {
        try {
            Language lang = DefaultLanguageService.getLanguageService().getLanguage(pair.languageID);
            try {
                lang.getCompilerSpecByID(pair.compilerSpecID);
                return pair;
            }
            catch (CompilerSpecNotFoundException e) {
                Msg.warn(OldLanguageMappingService.class, (Object)("Compiler spec not found: " + String.valueOf(pair.languageID) + "->" + String.valueOf(pair.compilerSpecID)));
                return new LanguageCompilerSpecPair(pair.languageID, lang.getDefaultCompilerSpec().getCompilerSpecID());
            }
        }
        catch (LanguageNotFoundException lnfe) {
            Msg.warn(OldLanguageMappingService.class, (Object)("Language not found: " + String.valueOf(pair.languageID)));
            return null;
        }
    }

    public static LanguageCompilerSpecPair processXmlLanguageString(String languageString) {
        if (languageString == null) {
            return null;
        }
        int index = languageString.lastIndexOf(58);
        if (index > 0) {
            LanguageCompilerSpecPair pair = new LanguageCompilerSpecPair(new LanguageID(languageString.substring(0, index)), new CompilerSpecID(languageString.substring(index + 1)));
            return OldLanguageMappingService.validatePair(pair);
        }
        return OldLanguageMappingService.lookupMagicString(languageString, true);
    }

    static {
        PluggableServiceRegistry.registerPluggableService(OldLanguageMappingService.class, (Object)new OldLanguageMappingService());
    }
}

