/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.lang;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.ParamEntry;
import ghidra.program.model.lang.ParamList;
import ghidra.program.model.lang.ParameterPieces;
import ghidra.program.model.lang.ProgramArchitecture;
import ghidra.program.model.lang.PrototypePieces;
import ghidra.program.model.lang.StorageClass;
import ghidra.program.model.lang.protorules.ConvertToPointer;
import ghidra.program.model.lang.protorules.ModelRule;
import ghidra.program.model.lang.protorules.SizeRestrictedFilter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.listing.VariableStorage;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.ElementId;
import ghidra.program.model.pcode.Encoder;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlParseException;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.util.ArrayList;

public class ParamListStandard
implements ParamList {
    protected Language language;
    protected int numgroup;
    protected boolean thisbeforeret;
    protected boolean autoKilledByCall;
    protected boolean splitMetatype;
    protected ParamEntry[] entry;
    protected ModelRule[] modelRules;
    protected AddressSpace spacebase;

    private int findEntry(Address loc, int size) {
        for (int i = 0; i < this.entry.length; ++i) {
            if (this.entry[i].getMinSize() > size || this.entry[i].justifiedContain(loc, size) != 0) continue;
            return i;
        }
        return -1;
    }

    public int assignAddressFallback(StorageClass resource, DataType tp, boolean matchExact, int[] status, ParameterPieces param) {
        for (ParamEntry element : this.entry) {
            int grp = element.getGroup();
            if (status[grp] < 0 || resource != element.getType() && (matchExact || element.getType() != StorageClass.GENERAL)) continue;
            status[grp] = element.getAddrBySlot(status[grp], tp.getAlignedLength(), tp.getAlignment(), param);
            if (param.address == null) continue;
            if (element.isExclusion()) {
                for (int group : element.getAllGroups()) {
                    status[group] = -1;
                }
            }
            param.type = tp;
            return 0;
        }
        param.address = null;
        return 1;
    }

    public int assignAddress(DataType dt, PrototypePieces proto, int pos, DataTypeManager dtManager, int[] status, ParameterPieces res) {
        ModelRule[] td;
        if (dt.isZeroLength()) {
            return 2;
        }
        if (dt == DataType.DEFAULT) {
            return 2;
        }
        if (dt instanceof TypeDef && (td = (ModelRule[])dt).getBaseDataType() == DataType.DEFAULT) {
            return 2;
        }
        for (ModelRule modelRule : this.modelRules) {
            int responseCode = modelRule.assignAddress(dt, proto, pos, dtManager, status, res);
            if (responseCode == 1) continue;
            return responseCode;
        }
        StorageClass store = ParamEntry.getBasicTypeClass(dt);
        return this.assignAddressFallback(store, dt, false, status, res);
    }

    public int getNumParamEntry() {
        return this.entry.length;
    }

    public ParamEntry getEntry(int index) {
        return this.entry[index];
    }

    public boolean isBigEndian() {
        return this.entry[0].isBigEndian();
    }

    @Override
    public void assignMap(PrototypePieces proto, DataTypeManager dtManager, ArrayList<ParameterPieces> res, boolean addAutoParams) {
        int i;
        int[] status = new int[this.numgroup];
        for (i = 0; i < this.numgroup; ++i) {
            status[i] = 0;
        }
        if (addAutoParams && res.size() == 2) {
            ParameterPieces last = res.get(res.size() - 1);
            if (last.hiddenReturnPtr) {
                this.assignAddressFallback(StorageClass.HIDDENRET, last.type, false, status, last);
            } else {
                this.assignAddress(last.type, proto, 0, dtManager, status, last);
            }
            last.hiddenReturnPtr = true;
        }
        for (i = 0; i < proto.intypes.size(); ++i) {
            ParameterPieces store = new ParameterPieces();
            res.add(store);
            int resCode = this.assignAddress(proto.intypes.get(i), proto, i, dtManager, status, store);
            if (resCode != 1 && resCode != 2) continue;
            ++i;
            while (i < proto.intypes.size()) {
                store = new ParameterPieces();
                res.add(store);
                ++i;
            }
            return;
        }
    }

    @Override
    public VariableStorage[] getPotentialRegisterStorage(Program prog) {
        ArrayList<VariableStorage> res = new ArrayList<VariableStorage>();
        for (ParamEntry element : this.entry) {
            ParamEntry pe = element;
            if (!pe.isExclusion() || !pe.getSpace().isRegisterSpace()) continue;
            VariableStorage var = null;
            try {
                var = new VariableStorage((ProgramArchitecture)prog, pe.getSpace().getAddress(pe.getAddressBase()), pe.getSize());
            }
            catch (InvalidInputException invalidInputException) {
                // empty catch block
            }
            if (var == null) continue;
            res.add(var);
        }
        VariableStorage[] arres = new VariableStorage[res.size()];
        res.toArray(arres);
        return arres;
    }

    @Override
    public void encode(Encoder encoder, boolean isInput) throws IOException {
        encoder.openElement(isInput ? ElementId.ELEM_INPUT : ElementId.ELEM_OUTPUT);
        if (this.thisbeforeret) {
            encoder.writeBool(AttributeId.ATTRIB_THISBEFORERETPOINTER, true);
        }
        encoder.writeBool(AttributeId.ATTRIB_KILLEDBYCALL, this.autoKilledByCall);
        if (isInput && !this.splitMetatype) {
            encoder.writeBool(AttributeId.ATTRIB_SEPARATEFLOAT, false);
        }
        int curgroup = -1;
        for (ParamEntry el : this.entry) {
            if (!(curgroup < 0 || el.isGrouped() && el.getGroup() == curgroup)) {
                encoder.closeElement(ElementId.ELEM_GROUP);
                curgroup = -1;
            }
            if (el.isGrouped() && curgroup < 0) {
                encoder.openElement(ElementId.ELEM_GROUP);
                curgroup = el.getGroup();
            }
            el.encode(encoder);
        }
        if (curgroup >= 0) {
            encoder.closeElement(ElementId.ELEM_GROUP);
        }
        for (ModelRule modelRule : this.modelRules) {
            modelRule.encode(encoder);
        }
        encoder.closeElement(isInput ? ElementId.ELEM_INPUT : ElementId.ELEM_OUTPUT);
    }

    private void parsePentry(XmlPullParser parser, CompilerSpec cspec, ArrayList<ParamEntry> pe, int groupid, boolean splitFloat, boolean grouped) throws XmlParseException {
        int[] groupSet;
        int maxgroup;
        StorageClass lastClass = StorageClass.CLASS4;
        if (!pe.isEmpty()) {
            ParamEntry lastEntry = pe.get(pe.size() - 1);
            lastClass = lastEntry.isGrouped() ? StorageClass.GENERAL : lastEntry.getType();
        }
        ParamEntry pentry = new ParamEntry(groupid);
        pe.add(pentry);
        pentry.restoreXml(parser, cspec, pe, grouped);
        if (splitFloat) {
            StorageClass currentClass;
            StorageClass storageClass = currentClass = grouped ? StorageClass.GENERAL : pentry.getType();
            if (lastClass != currentClass && lastClass.getValue() < currentClass.getValue()) {
                throw new XmlParseException("parameter list entries must be ordered by storage class");
            }
        }
        if (pentry.getSpace().isStackSpace()) {
            this.spacebase = pentry.getSpace();
        }
        if ((maxgroup = (groupSet = pentry.getAllGroups())[groupSet.length - 1] + 1) > this.numgroup) {
            this.numgroup = maxgroup;
        }
    }

    private void parseGroup(XmlPullParser parser, CompilerSpec cspec, ArrayList<ParamEntry> pe, int groupid, boolean splitFloat) throws XmlParseException {
        XmlElement el = parser.start(new String[]{ElementId.ELEM_GROUP.name()});
        int basegroup = this.numgroup;
        int count = 0;
        while (parser.peek().isStart()) {
            this.parsePentry(parser, cspec, pe, basegroup, splitFloat, true);
            ++count;
            ParamEntry lastEntry = pe.get(pe.size() - 1);
            if (lastEntry.getSpace().getType() != 6) continue;
            throw new XmlParseException("<pentry> in the join space not allowed in <group> tag");
        }
        for (int i = 1; i < count; ++i) {
            ParamEntry curEntry = pe.get(pe.size() - 1 - i);
            for (int j = 0; j < i; ++j) {
                ParamEntry.orderWithinGroup(curEntry, pe.get(pe.size() - 1 - j));
            }
        }
        parser.end(el);
    }

    @Override
    public void restoreXml(XmlPullParser parser, CompilerSpec cspec) throws XmlParseException {
        XmlElement subId;
        XmlElement el;
        ArrayList<ParamEntry> pe = new ArrayList<ParamEntry>();
        this.numgroup = 0;
        this.language = cspec.getLanguage();
        this.spacebase = null;
        int pointermax = 0;
        this.thisbeforeret = false;
        this.autoKilledByCall = false;
        this.splitMetatype = true;
        XmlElement mainel = parser.start(new String[0]);
        String attribute = mainel.getAttribute(AttributeId.ATTRIB_POINTERMAX.name());
        if (attribute != null) {
            pointermax = SpecXmlUtils.decodeInt((String)attribute);
        }
        if ((attribute = mainel.getAttribute(AttributeId.ATTRIB_THISBEFORERETPOINTER.name())) != null) {
            this.thisbeforeret = SpecXmlUtils.decodeBoolean((String)attribute);
        }
        if ((attribute = mainel.getAttribute(AttributeId.ATTRIB_KILLEDBYCALL.name())) != null) {
            this.autoKilledByCall = SpecXmlUtils.decodeBoolean((String)attribute);
        }
        if ((attribute = mainel.getAttribute(AttributeId.ATTRIB_SEPARATEFLOAT.name())) != null) {
            this.splitMetatype = SpecXmlUtils.decodeBoolean((String)attribute);
        }
        while ((el = parser.peek()).isStart()) {
            if (el.getName().equals(ElementId.ELEM_PENTRY.name())) {
                this.parsePentry(parser, cspec, pe, this.numgroup, this.splitMetatype, false);
                continue;
            }
            if (el.getName().equals(ElementId.ELEM_GROUP.name())) {
                this.parseGroup(parser, cspec, pe, this.numgroup, this.splitMetatype);
                continue;
            }
            if (!el.getName().equals(ElementId.ELEM_RULE.name())) continue;
            break;
        }
        this.entry = new ParamEntry[pe.size()];
        pe.toArray(this.entry);
        ArrayList<ModelRule> rules = new ArrayList<ModelRule>();
        while ((subId = parser.peek()).isStart()) {
            if (subId.getName().equals(ElementId.ELEM_RULE.name())) {
                ModelRule rule = new ModelRule();
                rule.restoreXml(parser, this);
                rules.add(rule);
                continue;
            }
            throw new XmlParseException("<pentry> and <group> elements must come before any <modelrule>");
        }
        parser.end(mainel);
        if (pointermax > 0) {
            SizeRestrictedFilter typeFilter = new SizeRestrictedFilter(pointermax + 1, 0);
            ConvertToPointer action = new ConvertToPointer(this);
            try {
                rules.add(new ModelRule(typeFilter, action, this));
            }
            catch (InvalidInputException e) {
                throw new XmlParseException(e.getMessage());
            }
        }
        this.modelRules = new ModelRule[rules.size()];
        rules.toArray(this.modelRules);
    }

    @Override
    public int getStackParameterAlignment() {
        for (ParamEntry pentry : this.entry) {
            if (!pentry.getSpace().isStackSpace()) continue;
            return pentry.getAlign();
        }
        return -1;
    }

    @Override
    public Long getStackParameterOffset() {
        for (ParamEntry element : this.entry) {
            ParamEntry pentry = element;
            if (pentry.isExclusion() || !pentry.getSpace().isStackSpace()) continue;
            long res = pentry.getAddressBase();
            if (pentry.isReverseStack()) {
                res += (long)pentry.getSize();
            }
            res = pentry.getSpace().truncateOffset(res);
            return res;
        }
        return null;
    }

    @Override
    public boolean possibleParamWithSlot(Address loc, int size, ParamList.WithSlotRec res) {
        if (loc == null) {
            return false;
        }
        int num = this.findEntry(loc, size);
        if (num == -1) {
            return false;
        }
        ParamEntry curentry = this.entry[num];
        res.slot = curentry.getSlot(loc, 0);
        res.slotsize = curentry.isExclusion() ? curentry.getAllGroups().length : (size - 1) / curentry.getAlign() + 1;
        return true;
    }

    @Override
    public Language getLanguage() {
        return this.language;
    }

    @Override
    public AddressSpace getSpacebase() {
        return this.spacebase;
    }

    @Override
    public boolean isEquivalent(ParamList obj) {
        int i;
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ParamListStandard op2 = (ParamListStandard)obj;
        if (this.entry.length != op2.entry.length) {
            return false;
        }
        for (i = 0; i < this.entry.length; ++i) {
            if (this.entry[i].isEquivalent(op2.entry[i])) continue;
            return false;
        }
        if (this.modelRules.length != op2.modelRules.length) {
            return false;
        }
        for (i = 0; i < this.modelRules.length; ++i) {
            if (this.modelRules[i].isEquivalent(op2.modelRules[i])) continue;
            return false;
        }
        if (this.numgroup != op2.numgroup) {
            return false;
        }
        if (!SystemUtilities.isEqual((Object)this.spacebase, (Object)op2.spacebase)) {
            return false;
        }
        if (this.thisbeforeret != op2.thisbeforeret) {
            return false;
        }
        return this.autoKilledByCall == op2.autoKilledByCall;
    }

    @Override
    public boolean isThisBeforeRetPointer() {
        return this.thisbeforeret;
    }

    public ParamEntry[] extractTiles(StorageClass resType) {
        ArrayList<ParamEntry> buffer = new ArrayList<ParamEntry>();
        for (int i = 0; i < this.entry.length; ++i) {
            ParamEntry pentry = this.entry[i];
            if (!pentry.isExclusion() || pentry.getAllGroups().length != 1 || pentry.getType() != resType) continue;
            buffer.add(pentry);
        }
        ParamEntry[] res = new ParamEntry[buffer.size()];
        buffer.toArray(res);
        return res;
    }

    public ParamEntry extractStack() {
        for (int i = this.entry.length - 1; i >= 0; --i) {
            ParamEntry pentry = this.entry[i];
            if (pentry.isExclusion() || !pentry.getSpace().isStackSpace()) continue;
            return pentry;
        }
        return null;
    }
}

