/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.pcode;

import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.Varnode;
import java.util.List;

public class VarnodeTranslator {
    Language language;

    public VarnodeTranslator(Language lang) {
        this.language = lang;
    }

    public VarnodeTranslator(Program program) {
        this(program.getLanguage());
    }

    public boolean supportsPcode() {
        return this.language.supportsPcode();
    }

    public Register getRegister(Varnode node) {
        if (node == null) {
            return null;
        }
        return this.language.getRegister(node.getAddress(), node.getSize());
    }

    public Varnode getVarnode(Register register) {
        Varnode node = new Varnode(register.getAddress(), register.getMinimumByteSize());
        return node;
    }

    public Register getRegister(String name) {
        return this.language.getRegister(name);
    }

    public List<Register> getRegisters() {
        return this.language.getRegisters();
    }
}

