/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb;

import ghidra.app.util.bin.format.pdb.PdbParser;
import ghidra.app.util.bin.format.pdb.PdbUtil;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.store.LockException;
import ghidra.program.database.sourcemap.SourceFile;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Program;
import ghidra.program.model.sourcemap.SourceFileManager;
import ghidra.util.Msg;
import ghidra.util.SourceFileUtils;
import ghidra.util.task.TaskMonitor;
import ghidra.util.xml.XmlUtilities;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;

class ApplyLineNumbers {
    private XmlPullParser xmlParser;
    private Program program;

    ApplyLineNumbers(PdbParser pdbParser, XmlPullParser xmlParser, Program program) {
        this.xmlParser = xmlParser;
        this.program = program;
    }

    void applyTo(TaskMonitor monitor, MessageLog log) {
        if (!this.program.hasExclusiveAccess()) {
            Msg.showWarn((Object)this, null, (String)"Cannot Apply SourceMap Information", (Object)"Exclusive access to the program is required to apply source map information");
            return;
        }
        SourceFileManager manager = this.program.getSourceFileManager();
        while (this.xmlParser.hasNext()) {
            CodeUnit cu;
            if (monitor.isCancelled()) {
                return;
            }
            XmlElement elem = this.xmlParser.peek();
            if (elem.isEnd() && elem.getName().equals("function")) break;
            elem = this.xmlParser.next();
            String sourceFilePath = elem.getAttribute("source_file");
            int start = XmlUtilities.parseInt((String)elem.getAttribute("start"));
            int addr = XmlUtilities.parseInt((String)elem.getAttribute("addr"));
            Address address = PdbUtil.reladdr(this.program, addr);
            long length = 0L;
            String lengthElem = elem.getAttribute("length");
            if (lengthElem != null) {
                length = XmlUtilities.parseLong((String)lengthElem);
            }
            if ((cu = this.program.getListing().getCodeUnitContaining(address)) == null) {
                log.appendMsg("PDB", "Skipping source map info (no code unit found at " + String.valueOf(address) + ")");
                continue;
            }
            try {
                SourceFile sourceFile = SourceFileUtils.getSourceFileFromPathString((String)sourceFilePath);
                manager.addSourceFile(sourceFile);
                manager.addSourceMapEntry(sourceFile, start, address, length);
            }
            catch (LockException e) {
                throw new AssertionError((Object)"LockException after exclusive access verified!");
            }
            catch (AddressOverflowException e) {
                log.appendMsg("PDB", "AddressOverflow for source map info: %s, %d, %s, %d".formatted(sourceFilePath, start, address.toString(), length));
            }
            catch (IllegalArgumentException e) {
                log.appendMsg("PDB", e.getMessage());
            }
            elem = this.xmlParser.next();
        }
    }
}

