/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.exec.trace;

import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.pcode.exec.BytesPcodeArithmetic;
import ghidra.pcode.exec.BytesPcodeExecutorState;
import ghidra.pcode.exec.PairedPcodeArithmetic;
import ghidra.pcode.exec.PcodeArithmetic;
import ghidra.pcode.exec.PcodeExecutor;
import ghidra.pcode.exec.PcodeExecutorState;
import ghidra.pcode.exec.PcodeExecutorStatePiece;
import ghidra.pcode.exec.PcodeExpression;
import ghidra.pcode.exec.PcodeStateCallbacks;
import ghidra.pcode.exec.SleighProgramCompiler;
import ghidra.pcode.exec.trace.TraceEmulationIntegration;
import ghidra.pcode.exec.trace.TraceMemoryStatePcodeArithmetic;
import ghidra.pcode.exec.trace.TraceMemoryStatePcodeExecutorStatePiece;
import ghidra.pcode.exec.trace.data.DefaultPcodeTraceAccess;
import ghidra.pcode.utils.Utils;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.trace.model.Trace;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.trace.model.thread.TraceThread;
import java.math.BigInteger;
import java.util.Map;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public final class TraceSleighUtils
extends Enum<TraceSleighUtils> {
    private static final /* synthetic */ TraceSleighUtils[] $VALUES;

    public static TraceSleighUtils[] values() {
        return (TraceSleighUtils[])$VALUES.clone();
    }

    public static TraceSleighUtils valueOf(String name) {
        return Enum.valueOf(TraceSleighUtils.class, name);
    }

    public static PcodeExecutor<byte[]> buildByteExecutor(TracePlatform platform, long snap, TraceThread thread, int frame) {
        Language language = platform.getLanguage();
        if (!(language instanceof SleighLanguage)) {
            throw new IllegalArgumentException("TracePlatform must use a Sleigh language");
        }
        SleighLanguage language2 = (SleighLanguage)language;
        DefaultPcodeTraceAccess access = new DefaultPcodeTraceAccess(platform, snap);
        PcodeStateCallbacks cb = TraceEmulationIntegration.bytesImmediateWrite(access, thread, frame);
        BytesPcodeExecutorState state = new BytesPcodeExecutorState((Language)language2, cb);
        return new PcodeExecutor(language2, (PcodeArithmetic)BytesPcodeArithmetic.forLanguage((Language)language2), (PcodeExecutorState)state, PcodeExecutorStatePiece.Reason.INSPECT);
    }

    public static PcodeExecutor<byte[]> buildByteExecutor(Trace trace, long snap, TraceThread thread, int frame) {
        return TraceSleighUtils.buildByteExecutor(trace.getPlatformManager().getHostPlatform(), snap, thread, frame);
    }

    public static PcodeExecutor<Pair<byte[], TraceMemoryState>> buildByteWithStateExecutor(TracePlatform platform, long snap, TraceThread thread, int frame) {
        Language language = platform.getLanguage();
        if (!(language instanceof SleighLanguage)) {
            throw new IllegalArgumentException("TracePlatform must use a Sleigh language");
        }
        SleighLanguage language2 = (SleighLanguage)language;
        DefaultPcodeTraceAccess access = new DefaultPcodeTraceAccess(platform, snap);
        PcodeStateCallbacks cb = TraceEmulationIntegration.bytesImmediateWrite(access, thread, frame);
        BytesPcodeExecutorState state = new BytesPcodeExecutorState((Language)language2, cb);
        PcodeExecutorState paired = state.paired((PcodeExecutorStatePiece)new TraceMemoryStatePcodeExecutorStatePiece(access.getDataForThreadState(thread, frame)));
        return new PcodeExecutor(language2, (PcodeArithmetic)new PairedPcodeArithmetic((PcodeArithmetic)BytesPcodeArithmetic.forLanguage((Language)language2), (PcodeArithmetic)TraceMemoryStatePcodeArithmetic.INSTANCE), paired, PcodeExecutorStatePiece.Reason.INSPECT);
    }

    public static PcodeExecutor<Pair<byte[], TraceMemoryState>> buildByteWithStateExecutor(Trace trace, long snap, TraceThread thread, int frame) {
        return TraceSleighUtils.buildByteWithStateExecutor(trace.getPlatformManager().getHostPlatform(), snap, thread, frame);
    }

    public static byte[] evaluateBytes(PcodeExpression expr, Trace trace, long snap, TraceThread thread, int frame) {
        SleighLanguage language = expr.getLanguage();
        if (trace.getBaseLanguage() != language) {
            throw new IllegalArgumentException("This expression can only be evaulated on traces with language " + String.valueOf(language));
        }
        PcodeExecutor<byte[]> executor = TraceSleighUtils.buildByteExecutor(trace, snap, thread, frame);
        return (byte[])expr.evaluate(executor);
    }

    public static BigInteger evaluate(PcodeExpression expr, Trace trace, long snap, TraceThread thread, int frame) {
        byte[] bytes = TraceSleighUtils.evaluateBytes(expr, trace, snap, thread, frame);
        return Utils.bytesToBigInteger((byte[])bytes, (int)bytes.length, (boolean)expr.getLanguage().isBigEndian(), (boolean)false);
    }

    public static Pair<byte[], TraceMemoryState> evaluateBytesWithState(PcodeExpression expr, Trace trace, long snap, TraceThread thread, int frame) {
        SleighLanguage language = expr.getLanguage();
        if (trace.getBaseLanguage() != language) {
            throw new IllegalArgumentException("This expression can only be evaulated on traces with language " + String.valueOf(language));
        }
        PcodeExecutor<Pair<byte[], TraceMemoryState>> executor = TraceSleighUtils.buildByteWithStateExecutor(trace, snap, thread, frame);
        return (Pair)expr.evaluate(executor);
    }

    public static Pair<BigInteger, TraceMemoryState> evaluateWithState(PcodeExpression expr, Trace trace, long snap, TraceThread thread, int frame) {
        Pair<byte[], TraceMemoryState> bytesPair = TraceSleighUtils.evaluateBytesWithState(expr, trace, snap, thread, frame);
        byte[] bytes = (byte[])bytesPair.getLeft();
        return new ImmutablePair((Object)Utils.bytesToBigInteger((byte[])bytes, (int)bytes.length, (boolean)expr.getLanguage().isBigEndian(), (boolean)false), (Object)((TraceMemoryState)((Object)bytesPair.getRight())));
    }

    public static byte[] evaluateBytes(String expr, Trace trace, long snap, TraceThread thread, int frame) {
        Language language = trace.getBaseLanguage();
        if (!(language instanceof SleighLanguage)) {
            throw new IllegalArgumentException("Trace must use a sleigh-based language");
        }
        return TraceSleighUtils.evaluateBytes(SleighProgramCompiler.compileExpression((SleighLanguage)((SleighLanguage)language), (String)expr), trace, snap, thread, frame);
    }

    public static BigInteger evaluate(String expr, Trace trace, long snap, TraceThread thread, int frame) {
        Language language = trace.getBaseLanguage();
        if (!(language instanceof SleighLanguage)) {
            throw new IllegalArgumentException("Trace must use a sleigh-based language");
        }
        return TraceSleighUtils.evaluate(SleighProgramCompiler.compileExpression((SleighLanguage)((SleighLanguage)language), (String)expr), trace, snap, thread, frame);
    }

    public static Map.Entry<byte[], TraceMemoryState> evaluateBytesWithState(String expr, Trace trace, long snap, TraceThread thread, int frame) {
        Language language = trace.getBaseLanguage();
        if (!(language instanceof SleighLanguage)) {
            throw new IllegalArgumentException("Trace must use a sleigh-based language");
        }
        return TraceSleighUtils.evaluateBytesWithState(SleighProgramCompiler.compileExpression((SleighLanguage)((SleighLanguage)language), (String)expr), trace, snap, thread, frame);
    }

    public static Map.Entry<BigInteger, TraceMemoryState> evaluateWithState(String expr, Trace trace, long snap, TraceThread thread, int frame) {
        Language language = trace.getBaseLanguage();
        if (!(language instanceof SleighLanguage)) {
            throw new IllegalArgumentException("Trace must use a sleigh-based language");
        }
        return TraceSleighUtils.evaluateWithState(SleighProgramCompiler.compileExpression((SleighLanguage)((SleighLanguage)language), (String)expr), trace, snap, thread, frame);
    }

    public static String generateExpressionForRange(Language language, AddressRange range) {
        AddressSpace space = range.getAddressSpace();
        long length = range.getLength();
        long offset = range.getMinAddress().getOffset();
        int ptrSize = space.getPointerSize();
        if (language != null && language.getDefaultSpace() == space) {
            return String.format("*:%d 0x%08x:%d", length, offset, ptrSize);
        }
        return String.format("*[%s]:%d 0x%08x:%d", space.getName(), length, offset, ptrSize);
    }

    private static /* synthetic */ TraceSleighUtils[] $values() {
        return new TraceSleighUtils[0];
    }

    static {
        $VALUES = TraceSleighUtils.$values();
    }
}

