/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.util;

import ghidra.docking.settings.Settings;
import ghidra.docking.settings.SettingsDefinition;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.MutabilitySettingsDefinition;
import ghidra.program.model.listing.Data;

public interface DataAdapterFromSettings
extends Data {
    default public <T extends SettingsDefinition> T getSettingsDefinition(Class<T> settingsDefinitionClass) {
        DataType dt = this.getBaseDataType();
        for (SettingsDefinition def : dt.getSettingsDefinitions()) {
            if (!settingsDefinitionClass.isAssignableFrom(def.getClass())) continue;
            return (T)((SettingsDefinition)settingsDefinitionClass.cast(def));
        }
        return null;
    }

    default public boolean hasMutability(int mutabilityType) {
        MutabilitySettingsDefinition def = this.getSettingsDefinition(MutabilitySettingsDefinition.class);
        if (def != null) {
            return def.getChoice((Settings)this) == mutabilityType;
        }
        return false;
    }

    default public boolean isConstant() {
        return this.hasMutability(2);
    }

    default public boolean isWritable() {
        return this.hasMutability(3);
    }

    default public boolean isVolatile() {
        return this.hasMutability(1);
    }
}

