/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.gui.search.results;

import docking.DialogComponentProvider;
import generic.theme.Gui;
import ghidra.features.bsim.gui.search.dialog.BSimFilterSet;
import ghidra.features.bsim.gui.search.dialog.BSimSearchSettings;
import ghidra.features.bsim.query.BSimServerInfo;
import ghidra.util.HelpLocation;
import ghidra.util.layout.PairLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class BSimSearchInfoDisplayDialog
extends DialogComponentProvider {
    private BSimServerInfo server;
    private BSimSearchSettings settings;
    private boolean isOverview;

    public BSimSearchInfoDisplayDialog(BSimServerInfo server, BSimSearchSettings searchSettings, boolean isOverview) {
        super("BSim Search Criteria");
        this.server = server;
        this.settings = searchSettings;
        this.isOverview = isOverview;
        this.addWorkPanel(this.buildWorkPanel());
        String anchor = isOverview ? "Overview_Search_Info_Action" : "Search_Info_Action";
        this.setHelpLocation(new HelpLocation("BSimSearchPlugin", anchor));
        this.setRememberSize(false);
        this.addOKButton();
    }

    private JComponent buildWorkPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.buildSearchInfoPanel(), "North");
        return panel;
    }

    private JPanel buildSearchInfoPanel() {
        JPanel panel = new JPanel((LayoutManager)new PairLayout(0, 10));
        panel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JLabel dataLabel = new JLabel("Search Options:");
        Gui.registerFont((JComponent)dataLabel, (int)2);
        panel.add(dataLabel);
        panel.add(new JLabel(""));
        panel.add(new JLabel("BSim Server:", 4));
        panel.add(this.getDisplayField(this.server.getDBName()));
        panel.add(new JLabel("Similarity Threshold:", 4));
        panel.add(this.getDisplayField(Double.toString(this.settings.getSimilarity())));
        panel.add(new JLabel("Confidence Threshold:", 4));
        panel.add(this.getDisplayField(Double.toString(this.settings.getConfidence())));
        if (!this.isOverview) {
            panel.add(new JLabel("Max Results:", 4));
            panel.add(this.getDisplayField(Integer.toString(this.settings.getMaxResults())));
            this.addFilters(panel);
        }
        return panel;
    }

    private void addFilters(JPanel panel) {
        panel.add(new JLabel(""));
        panel.add(new JLabel(""));
        JLabel filterLabel = new JLabel("Filters:");
        Gui.registerFont((JComponent)filterLabel, (int)2);
        panel.add(filterLabel);
        panel.add(new JLabel(""));
        BSimFilterSet bSimFilterSet = this.settings.getBSimFilterSet();
        List<BSimFilterSet.FilterEntry> filters = bSimFilterSet.getFilterEntries();
        if (filters.isEmpty()) {
            panel.add(new JLabel("None", 4));
            return;
        }
        for (BSimFilterSet.FilterEntry filter : filters) {
            panel.add(new JLabel(filter.filterType().getLabel() + ":", 4));
            panel.add(this.getDisplayField(this.getValueString(filter.values())));
        }
    }

    private JComponent getDisplayField(String data) {
        JTextField textField = new JTextField(data);
        textField.setEditable(false);
        return textField;
    }

    private String getValueString(List<String> values) {
        return values.stream().collect(Collectors.joining(",  "));
    }

    protected void okCallback() {
        this.close();
    }
}

