/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pty.unix;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.IntByReference;
import ghidra.pty.Pty;
import ghidra.pty.unix.PosixC;
import ghidra.pty.unix.UnixPtyChild;
import ghidra.pty.unix.UnixPtyParent;
import ghidra.pty.unix.Util;
import ghidra.util.Msg;
import java.io.IOException;

public class UnixPty
implements Pty {
    static final PosixC LIB_POSIX = PosixC.INSTANCE;
    private final int aparent;
    private final int achild;
    private boolean closed = false;
    private final UnixPtyParent parent;
    private final UnixPtyChild child;

    public static UnixPty openpty(PosixC.Ioctls ioctls) throws IOException {
        IntByReference p = new IntByReference();
        IntByReference c = new IntByReference();
        Memory n = new Memory(1024L);
        Util.INSTANCE.openpty(p, c, (Pointer)n, null, null);
        return new UnixPty(ioctls, p.getValue(), c.getValue(), n.getString(0L));
    }

    UnixPty(PosixC.Ioctls ioctls, int aparent, int achild, String name) {
        Msg.debug((Object)this, (Object)("New Pty: " + name + " at (" + aparent + "," + achild + ")"));
        this.aparent = aparent;
        this.achild = achild;
        this.parent = new UnixPtyParent(ioctls, aparent);
        this.child = new UnixPtyChild(ioctls, achild, name);
    }

    @Override
    public UnixPtyParent getParent() {
        return this.parent;
    }

    @Override
    public UnixPtyChild getChild() {
        return this.child;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.child.closeStreams();
        this.parent.closeStreams();
        LIB_POSIX.close(this.achild);
        LIB_POSIX.close(this.aparent);
        this.closed = true;
    }
}

