/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pty.windows;

import com.sun.jna.LastErrorException;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinBase;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import ghidra.pty.PtyChild;
import ghidra.pty.ShellUtils;
import ghidra.pty.local.LocalWindowsNativeProcessPtySession;
import ghidra.pty.windows.ConPty;
import ghidra.pty.windows.ConPtyEndpoint;
import ghidra.pty.windows.Handle;
import ghidra.pty.windows.PseudoConsoleHandle;
import ghidra.pty.windows.jna.ConsoleApiNative;
import ghidra.pty.windows.jna.JobApiNative;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

public class ConPtyChild
extends ConPtyEndpoint
implements PtyChild {
    public ConPtyChild(Handle writeHandle, Handle readHandle, PseudoConsoleHandle pseudoConsoleHandle) {
        super(writeHandle, readHandle, pseudoConsoleHandle);
    }

    protected ConsoleApiNative.STARTUPINFOEX prepareStartupInfo() {
        ConsoleApiNative.STARTUPINFOEX si = new ConsoleApiNative.STARTUPINFOEX();
        si.StartupInfo.cb = new WinDef.DWORD((long)si.size());
        si.StartupInfo.hStdOutput = new WinNT.HANDLE();
        si.StartupInfo.hStdError = new WinNT.HANDLE();
        si.StartupInfo.hStdInput = new WinNT.HANDLE();
        si.StartupInfo.dwFlags = 256;
        WinDef.UINTByReference bytesRequired = new WinDef.UINTByReference();
        ConsoleApiNative.INSTANCE.InitializeProcThreadAttributeList(null, ConPty.DW_ONE, ConPty.DW_ZERO, bytesRequired);
        si.lpAttributeList = new Memory((long)bytesRequired.getValue().intValue());
        if (!ConsoleApiNative.INSTANCE.InitializeProcThreadAttributeList(si.lpAttributeList, ConPty.DW_ONE, ConPty.DW_ZERO, bytesRequired).booleanValue()) {
            throw new LastErrorException(Kernel32.INSTANCE.GetLastError());
        }
        if (!ConsoleApiNative.INSTANCE.UpdateProcThreadAttribute(si.lpAttributeList, ConPty.DW_ZERO, ConPty.PROC_THREAD_ATTRIBUTE_PSEUDOCONSOLE, new WinDef.PVOID(this.pseudoConsoleHandle.getNative().getPointer()), new WinDef.DWORD((long)Native.POINTER_SIZE), null, null).booleanValue()) {
            throw new LastErrorException(Kernel32.INSTANCE.GetLastError());
        }
        return si;
    }

    @Override
    public LocalWindowsNativeProcessPtySession session(String[] args, Map<String, String> env, File workingDirectory, Collection<PtyChild.TermMode> mode) throws IOException {
        WinNT.HANDLE hJob = JobApiNative.INSTANCE.CreateJobObjectW(null, null);
        if (hJob == null) {
            throw new LastErrorException(Kernel32.INSTANCE.GetLastError());
        }
        ConsoleApiNative.STARTUPINFOEX si = this.prepareStartupInfo();
        WinBase.PROCESS_INFORMATION pi = new WinBase.PROCESS_INFORMATION();
        String commandLine = ShellUtils.generateLine(Arrays.asList(args));
        if (!ConsoleApiNative.INSTANCE.CreateProcessW(null, new WString(commandLine), null, null, false, new WinDef.DWORD(525312L), env == null ? null : new WString(ShellUtils.generateEnvBlock(env)), workingDirectory == null ? null : new WString(workingDirectory.getAbsolutePath()), si, pi).booleanValue()) {
            throw new LastErrorException(Kernel32.INSTANCE.GetLastError());
        }
        if (!JobApiNative.INSTANCE.AssignProcessToJobObject(hJob, pi.hProcess).booleanValue()) {
            throw new LastErrorException(Kernel32.INSTANCE.GetLastError());
        }
        return new LocalWindowsNativeProcessPtySession(pi.dwProcessId.intValue(), pi.dwThreadId.intValue(), new Handle(pi.hProcess), new Handle(pi.hThread), "ConPTY", new Handle(hJob));
    }

    @Override
    public String nullSession(Collection<PtyChild.TermMode> mode) throws IOException {
        throw new UnsupportedOperationException("ConPTY does not have a name");
    }

    @Override
    public void setWindowSize(short cols, short rows) {
        this.pseudoConsoleHandle.resize(rows, cols);
    }
}

