/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump.userdump;

import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.dump.DumpFileReader;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class UserdumpFileHeader
implements StructConverter {
    public static final String NAME = "USERDUMP_HEADER";
    private int signature;
    private int validDump;
    private int majorVersion;
    private int minorVersion;
    private int machineImageType;
    private int threadCount;
    private int moduleCount;
    private int memoryRegionCount;
    private long threadOffset;
    private long moduleOffset;
    private long memoryRegionOffset;
    private long memoryDescriptorOffset;
    private long debugEventOffset;
    private long threadStateOffset;
    protected DumpFileReader reader;
    protected long index;
    private int psz;

    UserdumpFileHeader(DumpFileReader reader, long index) throws IOException {
        this.reader = reader;
        this.index = index;
        this.psz = reader.getPointerSize();
        this.parse();
    }

    protected void parse() throws IOException {
        this.reader.setPointerIndex(this.index);
        this.setSignature(this.reader.readNextInt());
        this.setValidDump(this.reader.readNextInt());
        this.setMajorVersion(this.reader.readNextInt());
        this.setMinorVersion(this.reader.readNextInt());
        this.setMachineImageType(this.reader.readNextInt());
        this.setThreadCount(this.reader.readNextInt());
        this.setModuleCount(this.reader.readNextInt());
        this.setMemoryRegionCount(this.reader.readNextInt());
        this.setThreadOffset(this.readNextPointer());
        this.setModuleOffset(this.readNextPointer());
        this.setMemoryRegionOffset(this.readNextPointer());
        this.setMemoryDescriptorOffset(this.readNextPointer());
        this.setDebugEventOffset(this.readNextPointer());
        this.setThreadStateOffset(this.readNextPointer());
    }

    public DataType toDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(STRING, 4, "Signature", null);
        struct.add(STRING, 4, "ValidDump", null);
        struct.add(DWORD, 4, "MajorVersion", null);
        struct.add(DWORD, 4, "MinorVersion", null);
        struct.add(DWORD, 4, "MachineImageType", null);
        struct.add(DWORD, 4, "NumberOfThreads", null);
        struct.add(DWORD, 4, "ModuleCount", null);
        struct.add(DWORD, 4, "MemoryRegionCount", null);
        struct.add(POINTER, this.psz, "ThreadContextOffset", null);
        struct.add(POINTER, this.psz, "ModulesOffset", null);
        struct.add(POINTER, this.psz, "MemoryRegionOffset", null);
        struct.add(POINTER, this.psz, "MemoryDescriptorOffset", null);
        struct.add(POINTER, this.psz, "DebugEventOffset", null);
        struct.add(POINTER, this.psz, "ThreadStateOffset", null);
        struct.setCategoryPath(new CategoryPath("/UDMP"));
        return struct;
    }

    public int getSignature() {
        return this.signature;
    }

    public void setSignature(int signature) {
        this.signature = signature;
    }

    public int getValidDump() {
        return this.validDump;
    }

    public void setValidDump(int validDump) {
        this.validDump = validDump;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public void setMajorVersion(int majorVersion) {
        this.majorVersion = majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public void setMinorVersion(int minorVersion) {
        this.minorVersion = minorVersion;
    }

    public int getMachineImageType() {
        return this.machineImageType;
    }

    public void setMachineImageType(int machineImageType) {
        this.machineImageType = machineImageType;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public int getModuleCount() {
        return this.moduleCount;
    }

    public void setModuleCount(int moduleCount) {
        this.moduleCount = moduleCount;
    }

    public int getMemoryRegionCount() {
        return this.memoryRegionCount;
    }

    public void setMemoryRegionCount(int memoryRegionCount) {
        this.memoryRegionCount = memoryRegionCount;
    }

    public long getThreadOffset() {
        return this.threadOffset;
    }

    public void setThreadOffset(long threadOffset) {
        this.threadOffset = threadOffset;
    }

    public long getModuleOffset() {
        return this.moduleOffset;
    }

    public void setModuleOffset(long moduleOffset) {
        this.moduleOffset = moduleOffset;
    }

    public long getMemoryRegionOffset() {
        return this.memoryRegionOffset;
    }

    public void setMemoryRegionOffset(long memoryRegionOffset) {
        this.memoryRegionOffset = memoryRegionOffset;
    }

    public long getMemoryDescriptorOffset() {
        return this.memoryDescriptorOffset;
    }

    public void setMemoryDescriptorOffset(long memoryDescriptorOffset) {
        this.memoryDescriptorOffset = memoryDescriptorOffset;
    }

    public long getDebugEventOffset() {
        return this.debugEventOffset;
    }

    public void setDebugEventOffset(long debugEventOffset) {
        this.debugEventOffset = debugEventOffset;
    }

    public long getThreadStateOffset() {
        return this.threadStateOffset;
    }

    public void setThreadStateOffset(long threadStateOffset) {
        this.threadStateOffset = threadStateOffset;
    }

    private long readNextPointer() throws IOException {
        return this.psz == 4 ? (long)this.reader.readNextInt() : this.reader.readNextLong();
    }
}

