/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.data;

import ghidra.framework.cmd.Command;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.util.Msg;

public class CreateArrayInStructureCmd
implements Command<Program> {
    private String msg;
    private Address addr;
    private int numElements;
    private DataType dataType;
    private int[] compPath;

    public CreateArrayInStructureCmd(Address addr, int numElements, DataType dt, int[] compPath) {
        this.addr = addr;
        this.numElements = numElements;
        this.dataType = dt;
        this.compPath = compPath;
    }

    public boolean applyTo(Program program) {
        Listing listing = program.getListing();
        Data data = listing.getDataContaining(this.addr);
        Data compData = data.getComponent(this.compPath);
        if (compData == null) {
            this.msg = "Invalid target component path specified";
            return false;
        }
        int index = compData.getComponentIndex();
        int offset = compData.getParentOffset();
        DataType parentDataType = compData.getParent().getBaseDataType();
        if (!(parentDataType instanceof Structure)) {
            this.msg = "Data not in a structure";
            return false;
        }
        Structure struct = (Structure)parentDataType;
        DataType baseDt = this.dataType;
        if (this.dataType instanceof TypeDef) {
            baseDt = ((TypeDef)this.dataType).getBaseDataType();
        }
        if (baseDt instanceof Dynamic) {
            this.msg = "Dynamic data-type may not be specified: " + this.dataType.getName();
            return false;
        }
        try {
            int length;
            ArrayDataType adt = new ArrayDataType(this.dataType, this.numElements, this.dataType.getLength());
            int n = length = adt.isZeroLength() ? 0 : adt.getLength();
            if (!struct.isPackingEnabled() && offset + length > struct.getLength()) {
                this.msg = "Array too big for structure";
                return false;
            }
            this.clearStruct(struct, compData.getParentOffset(), length);
            if (struct.isPackingEnabled()) {
                struct.insert(index, (DataType)adt, -1);
            } else {
                struct.replace(index, (DataType)adt, -1);
            }
        }
        catch (RuntimeException e) {
            this.msg = "Unexpected error: " + e.toString();
            Msg.error((Object)this, (Object)this.msg, (Throwable)e);
            return false;
        }
        return true;
    }

    private void clearStruct(Structure struct, int offset, int length) {
        DataTypeComponent[] comps = struct.getDefinedComponents();
        int endOffset = offset + length;
        for (int i = comps.length - 1; i >= 0; --i) {
            if (comps[i].getOffset() < offset || comps[i].getOffset() >= endOffset) continue;
            struct.clearComponent(comps[i].getOrdinal());
        }
    }

    public String getStatusMsg() {
        return this.msg;
    }

    public String getName() {
        return "Create Array";
    }
}

