/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.cmd.refs;

import ghidra.framework.cmd.Command;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;

public class UpdateExternalNameCmd
implements Command<Program> {
    private String oldName;
    private String newName;
    private SourceType source;
    private String status;

    public UpdateExternalNameCmd(String oldName, String newName, SourceType source) {
        this.oldName = oldName;
        this.newName = newName;
        this.source = source;
        if (newName == null || newName.length() == 0) {
            throw new IllegalArgumentException("newName is invalid");
        }
    }

    public boolean applyTo(Program program) {
        try {
            program.getExternalManager().updateExternalLibraryName(this.oldName, this.newName, this.source);
            return true;
        }
        catch (DuplicateNameException e) {
            this.status = this.newName + " already exists";
        }
        catch (InvalidInputException e) {
            this.status = e.getMessage();
        }
        return false;
    }

    public String getStatusMsg() {
        return this.status;
    }

    public String getName() {
        return "Update External Program Name";
    }
}

