/*
 * Decompiled with CFR 0.152.
 */
package ghidra.javaclass.format.constantpool;

import ghidra.app.util.bin.BinaryReader;
import ghidra.javaclass.format.constantpool.AbstractConstantPoolInfoJava;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class ConstantPoolFloatInfo
extends AbstractConstantPoolInfoJava {
    private int bytes;

    public ConstantPoolFloatInfo(BinaryReader reader) throws IOException {
        super(reader);
        this.bytes = reader.readNextInt();
    }

    public int getRawBytes() {
        return this.bytes;
    }

    public float getValue() {
        return Float.intBitsToFloat(this.bytes);
    }

    public String toString() {
        return "" + this.getValue();
    }

    public DataType toDataType() throws DuplicateNameException, IOException {
        String name = "CONSTANT_Float_info";
        StructureDataType structure = new StructureDataType(name, 0);
        structure.add(BYTE, "tag", null);
        structure.add(DWORD, "bytes", null);
        return structure;
    }
}

