/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.ir.ts;

import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.LocalVar;
import com.googlecode.dex2jar.ir.Trap;
import com.googlecode.dex2jar.ir.stmt.BaseSwitchStmt;
import com.googlecode.dex2jar.ir.stmt.JumpStmt;
import com.googlecode.dex2jar.ir.stmt.LabelStmt;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import com.googlecode.dex2jar.ir.stmt.StmtList;
import com.googlecode.dex2jar.ir.ts.Transformer;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CleanLabel
implements Transformer {
    @Override
    public void transform(IrMethod irMethod) {
        HashSet<LabelStmt> useLabels = new HashSet<LabelStmt>();
        this.addTrap(irMethod.traps, useLabels);
        this.addVars(irMethod.vars, useLabels);
        this.addStmt(irMethod.stmts, useLabels);
        if (irMethod.phiLabels != null) {
            useLabels.addAll(irMethod.phiLabels);
        }
        this.addLineNumber(irMethod.stmts, useLabels);
        this.rmUnused(irMethod.stmts, useLabels);
    }

    private void addVars(List<LocalVar> vars, Set<LabelStmt> useLabels) {
        if (vars != null) {
            for (LocalVar var : vars) {
                useLabels.add(var.start);
                useLabels.add(var.end);
            }
        }
    }

    private void rmUnused(StmtList stmts, Set<LabelStmt> useLabels) {
        Stmt p = stmts.getFirst();
        while (p != null) {
            if (p instanceof LabelStmt && p.st == Stmt.ST.LABEL && !useLabels.contains(p)) {
                Stmt q = p.getNext();
                stmts.remove(p);
                p = q;
                continue;
            }
            p = p.getNext();
        }
    }

    private void addStmt(StmtList stmts, Set<LabelStmt> labels) {
        for (Stmt p = stmts.getFirst(); p != null; p = p.getNext()) {
            if (p instanceof JumpStmt) {
                labels.add(((JumpStmt)((Object)p)).getTarget());
                continue;
            }
            if (!(p instanceof BaseSwitchStmt)) continue;
            BaseSwitchStmt stmt = (BaseSwitchStmt)p;
            labels.add(stmt.defaultTarget);
            Collections.addAll(labels, stmt.targets);
        }
    }

    private void addTrap(List<Trap> traps, Set<LabelStmt> labels) {
        if (traps != null) {
            for (Trap trap : traps) {
                labels.add(trap.start);
                labels.add(trap.end);
                Collections.addAll(labels, trap.handlers);
            }
        }
    }

    private void addLineNumber(StmtList stmts, Set<LabelStmt> useLabels) {
        for (Stmt p = stmts.getFirst(); p != null; p = p.getNext()) {
            if (!(p instanceof LabelStmt) || ((LabelStmt)p).lineNumber == -1) continue;
            useLabels.add((LabelStmt)p);
        }
    }
}

