/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.taint;

import ghidra.app.decompiler.ClangFuncNameToken;
import ghidra.app.plugin.core.decompiler.taint.AbstractTaintState;
import ghidra.app.plugin.core.decompiler.taint.TaintLabel;
import ghidra.app.plugin.core.decompiler.taint.TaintPlugin;
import ghidra.app.script.GhidraScript;
import ghidra.app.services.ConsoleService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFormatException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.HighParam;
import ghidra.program.model.pcode.HighVariable;
import ghidra.trace.model.Trace;
import ghidra.trace.model.memory.TraceMemoryManager;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.model.memory.TraceMemorySpace;
import ghidra.trace.model.memory.TraceMemoryState;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.Msg;
import ghidra.util.NumericUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;

public class AngrTaintState
extends AbstractTaintState {
    private DebuggerTraceManagerService traceManager;
    private Address start;

    public AngrTaintState(TaintPlugin plugin) {
        super(plugin);
        ENGINE_NAME = "angr";
        this.usesIndex = false;
    }

    public void buildQuery(List<String> paramList, String enginePath, File indexDBFile, String indexDirectory) {
        paramList.add("python");
        paramList.add(enginePath);
    }

    public void buildIndex(List<String> paramList, String enginePath, String factsPath, String indexDirectory) {
    }

    public GhidraScript getExportScript(ConsoleService console, boolean perFunction) {
        return null;
    }

    protected void writeHeader(PrintWriter writer) {
        Program currentProgram = this.plugin.getCurrentProgram();
        this.start = currentProgram.getMaxAddress().getNewAddress(Integer.MAX_VALUE);
        writer.println("{");
        writer.println("\t\"binary_file\":\"" + currentProgram.getExecutablePath() + "\",");
        writer.println("\t\"base_address\":\"" + Long.toHexString(currentProgram.getImageBase().getOffset()) + "\",");
    }

    protected void writeRule(PrintWriter writer, TaintLabel mark, boolean isSource) {
        Program currentProgram = this.plugin.getCurrentProgram();
        Address addr = mark.getAddress();
        if (isSource) {
            if (this.start.getOffset() > addr.getOffset()) {
                this.start = addr;
            }
        } else {
            writer.println("\t\"find_address\":\"" + Long.toHexString(addr.getOffset()) + "\",");
            return;
        }
        if (isSource) {
            if (mark.getToken() instanceof ClangFuncNameToken) {
                CodeUnit cu = currentProgram.getListing().getCodeUnitAt(addr);
                writer.println("\t\"hooks\":[{\"" + Long.toHexString(addr.getOffset()) + "\":{\"length\":\"" + cu.getLength() + "\"}}],");
                return;
            }
            HighVariable highVariable = mark.getHighVariable();
            if (highVariable instanceof HighParam) {
                HighParam hp = (HighParam)highVariable;
                writer.println("\t\"arguments\":{\"" + hp.getSlot() + "\":\"" + mark.getSize() + "\"},");
                return;
            }
            Address vaddr = mark.getVarnodeAddress();
            if (vaddr != null) {
                if (vaddr.isRegisterAddress()) {
                    Language language = currentProgram.getLanguage();
                    Register register = language.getRegister(vaddr, mark.getSize());
                    writer.println("\t\"regs_vals\":{\"" + register.getName() + "\":\"" + mark.getSize() + "\"},");
                }
                if (vaddr.isMemoryAddress()) {
                    writer.println("\t\"vectors\":{\"" + String.valueOf(vaddr) + "\":\"" + mark.getSize() + "\"},");
                }
            }
        }
    }

    public void writeGate(PrintWriter writer, TaintLabel mark) {
        Address addr = mark.getAddress();
        writer.println("\t\"avoid_address\":\"" + Long.toHexString(addr.getOffset()) + "\",");
    }

    protected void writeFooter(PrintWriter writer) {
        this.writeState(writer);
        writer.println("\t\"blank_state\":\"" + Long.toHexString(this.start.getOffset()) + "\",");
        writer.println("\t\"auto_load_libs\":false");
        writer.println("}");
    }

    private void writeState(PrintWriter writer) {
        DebuggerCoordinates current;
        Trace trace;
        if (this.traceManager == null) {
            this.traceManager = (DebuggerTraceManagerService)this.plugin.getTool().getService(DebuggerTraceManagerService.class);
            if (this.traceManager == null) {
                return;
            }
        }
        if ((trace = (current = this.traceManager.getCurrent()).getTrace()) == null) {
            return;
        }
        TraceMemoryManager memoryManager = trace.getMemoryManager();
        Collection allRegions = memoryManager.getRegionsAtSnap(current.getSnap());
        for (TraceMemoryRegion region : allRegions) {
            AddressRange range = region.getRange(current.getSnap());
            Address min = range.getMinAddress();
            int len = (int)range.getLength();
            byte[] bytes = new byte[len];
            int nread = memoryManager.getBytes(current.getSnap(), min, ByteBuffer.wrap(bytes));
            if (nread == len) {
                writer.println("\t\"mem_store\":{\"" + String.valueOf(min) + "\":\"" + this.convert(bytes) + "\"},");
                continue;
            }
            Msg.error((Object)((Object)this), (Object)("Requested " + len + " but returned " + nread));
        }
        Program currentProgram = this.plugin.getCurrentProgram();
        List registers = currentProgram.getLanguage().getRegisters();
        TraceThread thread = current.getThread();
        if (thread == null) {
            return;
        }
        TraceMemorySpace regs = memoryManager.getMemoryRegisterSpace(thread, current.getFrame(), true);
        if (regs == null) {
            return;
        }
        for (Register r : registers) {
            RegisterValue value;
            byte[] bytes;
            String bytestr;
            TraceMemoryState state = regs.getState(current.getPlatform(), current.getSnap(), r);
            if (!state.equals((Object)TraceMemoryState.KNOWN) || (bytestr = this.convert(bytes = (value = regs.getValue(current.getSnap(), r)).getUnsignedValue().toByteArray())).equals("") || bytestr.equals("00")) continue;
            writer.println("\t\"regs_vals\":{\"" + r.getName() + "\":\"0x" + this.convert(bytes) + "\"},");
        }
    }

    private String convert(byte[] bytes) {
        return NumericUtilities.convertBytesToString((byte[])bytes);
    }

    protected void readQueryResultsIntoDataFrame(Program program, InputStream is) {
        Program currentProgram = this.plugin.getCurrentProgram();
        String line = null;
        this.taintAddressSet.clear();
        this.taintVarnodeMap.clear();
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(is));
            while ((line = bufferedReader.readLine()) != null) {
                if (line.startsWith("t:")) {
                    String addrStr = line.substring(line.indexOf(":") + 1);
                    Address address = currentProgram.getMinAddress().getAddress(addrStr);
                    this.taintAddressSet.add(address);
                    continue;
                }
                System.err.println(line);
            }
            bufferedReader.close();
        }
        catch (AddressFormatException | IOException e) {
            this.plugin.consoleMessage("IO Error Reading Query Results from Process: " + e.getMessage());
        }
    }
}

