/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.SymbolPath;
import ghidra.app.util.bin.format.pdb2.pdbreader.Numeric;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractComplexMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractEnumMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractEnumerateMsType;
import ghidra.app.util.bin.format.pdb2.pdbreader.type.AbstractMsType;
import ghidra.app.util.pdb.pdbapplicator.AbstractComplexTypeApplier;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.FieldListTypeApplier;
import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.EnumDataType;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import java.util.List;

public class EnumTypeApplier
extends AbstractComplexTypeApplier {
    public EnumTypeApplier(DefaultPdbApplicator applicator) {
        super(applicator);
    }

    private long getMask(AbstractEnumMsType type) {
        switch (this.getLength(type)) {
            case 1: {
                return 255L;
            }
            case 2: {
                return 65535L;
            }
            case 4: {
                return 0xFFFFFFFFL;
            }
        }
        return -1L;
    }

    private int getLength(AbstractEnumMsType type) {
        DataType underlyingDataType = this.getUnderlyingDataType(type);
        if (underlyingDataType == null) {
            return 1;
        }
        return Integer.max(underlyingDataType.getLength(), 1);
    }

    private DataType getUnderlyingDataType(AbstractEnumMsType type) {
        RecordNumber underlyingRecordNumber = type.getUnderlyingRecordNumber();
        return this.applicator.getDataType(underlyingRecordNumber);
    }

    boolean isSigned(AbstractEnumMsType type) {
        DataType underlyingType = this.getUnderlyingDataType(type);
        if (underlyingType == null) {
            return false;
        }
        if (underlyingType instanceof AbstractIntegerDataType) {
            return ((AbstractIntegerDataType)underlyingType).isSigned();
        }
        return false;
    }

    private EnumDataType createEmptyEnum(AbstractEnumMsType type) {
        AbstractEnumMsType defType = this.getDefinitionType(type);
        SymbolPath fixedPath = this.getFixedSymbolPath(defType);
        CategoryPath categoryPath = this.applicator.getCategory(fixedPath.getParent());
        EnumDataType enumDataType = new EnumDataType(categoryPath, fixedPath.getName(), this.getLength(defType), this.applicator.getDataTypeManager());
        return enumDataType;
    }

    @Override
    boolean apply(AbstractMsType type) throws PdbException, CancelledException {
        AbstractEnumMsType definedEnum = (AbstractEnumMsType)this.applicator.getMappedTypeRecord(type.getRecordNumber());
        EnumDataType enumDataType = this.createEmptyEnum(definedEnum);
        this.applyEnumMsType(enumDataType, definedEnum);
        EnumDataType dataType = enumDataType;
        this.applicator.putDataType(definedEnum, (DataType)dataType);
        return true;
    }

    private EnumDataType applyEnumMsType(EnumDataType enumDataType, AbstractEnumMsType type) throws PdbException {
        if (enumDataType.getCount() != 0) {
            return enumDataType;
        }
        String fullPathName = type.getName();
        RecordNumber fieldListRecordNumber = type.getFieldDescriptorListRecordNumber();
        FieldListTypeApplier fieldListApplier = FieldListTypeApplier.getFieldListApplierSpecial(this.applicator, fieldListRecordNumber);
        FieldListTypeApplier.FieldLists lists = fieldListApplier.getFieldLists(fieldListRecordNumber);
        if (!lists.methods().isEmpty()) {
            SymbolPath sp = this.getFixedSymbolPath(type);
            this.applicator.predefineClass(sp);
        }
        List<AbstractEnumerateMsType> enumerates = lists.enumerates();
        int numElements = type.getNumElements();
        if (enumerates.size() != numElements) {
            this.pdbLogAndInfoMessage(this, "Enum expecting " + numElements + " elements, but only " + enumerates.size() + " available for " + fullPathName);
        }
        int length = this.getLength(type);
        boolean isSigned = this.isSigned(type);
        for (AbstractEnumerateMsType enumerateType : enumerates) {
            SymbolPath memberSymbolPath = new SymbolPath(enumerateType.getName());
            enumDataType.add(memberSymbolPath.getName(), this.narrowingConversion(type, length, isSigned, enumerateType.getNumeric()));
        }
        return enumDataType;
    }

    private long narrowingConversion(AbstractEnumMsType type, int outputSize, boolean outputSigned, Numeric numeric) {
        if (!numeric.isIntegral()) {
            Msg.info((Object)this, (Object)("Non-integral numeric found: " + String.valueOf(numeric)));
            return 0L;
        }
        if (!numeric.isIntegral()) {
            this.pdbLogAndInfoMessage(this, "Using zero in place of non-integral enumerate: " + String.valueOf(numeric));
            return 0L;
        }
        return numeric.getIntegral().longValue() & this.getMask(type);
    }

    private AbstractEnumMsType getDefinitionType(AbstractComplexMsType type) {
        return this.getDefinitionType(type, AbstractEnumMsType.class);
    }
}

