/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.target.visitors;

import ghidra.trace.database.target.visitors.TreeTraversal;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectValPath;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.trace.model.target.path.KeyPath;
import ghidra.trace.model.target.path.PathFilter;
import java.util.Set;
import java.util.stream.Stream;

public class AncestorsRelativeVisitor
implements TreeTraversal.SpanIntersectingVisitor {
    protected final PathFilter filter;

    public AncestorsRelativeVisitor(PathFilter filter) {
        this.filter = filter;
    }

    @Override
    public TraceObjectValPath composePath(TraceObjectValPath pre, TraceObjectValue value) {
        return pre == null ? TraceObjectValPath.of() : pre.prepend(value);
    }

    @Override
    public TreeTraversal.VisitResult visitValue(TraceObjectValue value, TraceObjectValPath valPath) {
        KeyPath path = valPath.getPath();
        return TreeTraversal.VisitResult.result(this.filter.matches(path), this.filter.ancestorCouldMatchRight(path, true) && value.isObject());
    }

    @Override
    public TraceObject continueObject(TraceObjectValue value) {
        return value.getParent();
    }

    @Override
    public Stream<? extends TraceObjectValue> continueValues(TraceObject object, Lifespan span, TraceObjectValPath pre) {
        Set<String> prevKeys = this.filter.getPrevKeys(pre.getPath());
        if (prevKeys.isEmpty()) {
            return Stream.empty();
        }
        return object.getParents(span).stream().filter(v -> PathFilter.anyMatches(prevKeys, v.getEntryKey()));
    }
}

