/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.symbol;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Register;
import ghidra.program.model.symbol.SourceType;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.symbol.TraceLabelSymbol;
import ghidra.trace.model.symbol.TraceNamespaceSymbol;
import ghidra.trace.model.symbol.TraceSymbolWithLocationView;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.TraceRegisterUtils;
import ghidra.util.exception.InvalidInputException;

public interface TraceLabelSymbolView
extends TraceSymbolWithLocationView<TraceLabelSymbol> {
    public TraceLabelSymbol add(Lifespan var1, Address var2, String var3, TraceNamespaceSymbol var4, SourceType var5) throws InvalidInputException;

    default public TraceLabelSymbol create(long snap, Address address, String name, TraceNamespaceSymbol parent, SourceType source) throws InvalidInputException {
        return this.add(Lifespan.nowOn(snap), address, name, parent, source);
    }

    default public TraceLabelSymbol add(TracePlatform platform, Lifespan lifespan, TraceThread thread, Register register, String name, TraceNamespaceSymbol parent, SourceType source) throws InvalidInputException {
        TraceRegisterUtils.requireByteBound(register);
        AddressSpace space = TraceRegisterUtils.getRegisterAddressSpace(thread, 0, true);
        AddressRange range = platform.getConventionalRegisterRange(space, register);
        return this.add(lifespan, range.getMinAddress(), name, parent, source);
    }

    default public TraceLabelSymbol add(Lifespan lifespan, TraceThread thread, Register register, String name, TraceNamespaceSymbol parent, SourceType source) throws InvalidInputException {
        return this.add(this.getTrace().getPlatformManager().getHostPlatform(), lifespan, thread, register, name, parent, source);
    }

    default public TraceLabelSymbol create(long snap, TraceThread thread, Register register, String name, TraceNamespaceSymbol parent, SourceType source) throws InvalidInputException {
        return this.add(this.getTrace().getPlatformManager().getHostPlatform(), Lifespan.nowOn(snap), thread, register, name, parent, source);
    }

    default public TraceLabelSymbol create(TracePlatform platform, long snap, TraceThread thread, Register register, String name, TraceNamespaceSymbol parent, SourceType source) throws InvalidInputException {
        return this.add(platform, Lifespan.nowOn(snap), thread, register, name, parent, source);
    }
}

