/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions.associate;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypeSyncState;
import ghidra.app.plugin.core.datamgr.DataTypeSynchronizer;
import ghidra.app.plugin.core.datamgr.DataTypesActionContext;
import ghidra.app.plugin.core.datamgr.archive.DataTypeManagerHandler;
import ghidra.app.plugin.core.datamgr.tree.DataTypeNode;
import ghidra.app.plugin.core.datamgr.util.DataTypeUtils;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.SourceArchive;
import ghidra.util.Msg;
import java.awt.Component;
import javax.swing.tree.TreePath;

public class RevertDataTypeAction
extends DockingAction {
    private final DataTypeManagerPlugin plugin;

    public RevertDataTypeAction(DataTypeManagerPlugin plugin) {
        super("Revert Data Type", plugin.getName());
        this.plugin = plugin;
        this.setPopupMenuData(new MenuData(new String[]{"Revert Changes"}, "Sync"));
        this.setEnabled(true);
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof DataTypesActionContext)) {
            return false;
        }
        Object contextObject = context.getContextObject();
        GTree gTree = (GTree)contextObject;
        TreePath[] selectionPaths = gTree.getSelectionPaths();
        if (selectionPaths == null || selectionPaths.length != 1) {
            return false;
        }
        GTreeNode node = (GTreeNode)selectionPaths[0].getLastPathComponent();
        if (!(node instanceof DataTypeNode)) {
            return false;
        }
        DataTypeNode dataTypeNode = (DataTypeNode)node;
        DataType dataType = dataTypeNode.getDataType();
        DataTypeManagerHandler handler = this.plugin.getDataTypeManagerHandler();
        DataTypeSyncState syncStatus = DataTypeSynchronizer.getSyncStatus(handler, dataType);
        switch (syncStatus) {
            case UNKNOWN: {
                return false;
            }
            case COMMIT: 
            case CONFLICT: {
                return true;
            }
            case IN_SYNC: 
            case ORPHAN: 
            case UPDATE: {
                return false;
            }
        }
        return false;
    }

    public void actionPerformed(ActionContext context) {
        GTree gTree = (GTree)context.getContextObject();
        TreePath[] selectionPaths = gTree.getSelectionPaths();
        if (selectionPaths == null || selectionPaths.length != 1) {
            return;
        }
        GTreeNode node = (GTreeNode)selectionPaths[0].getLastPathComponent();
        DataTypeNode dataTypeNode = (DataTypeNode)node;
        DataType dataType = dataTypeNode.getDataType();
        DataTypeManager dtm = dataType.getDataTypeManager();
        DataTypeManagerHandler handler = this.plugin.getDataTypeManagerHandler();
        SourceArchive sourceArchive = dataType.getSourceArchive();
        if (!dtm.isUpdatable()) {
            DataTypeUtils.showUnmodifiableArchiveErrorMessage((Component)gTree, "Revert Failed", dtm);
            return;
        }
        DataTypeManager sourceDTM = handler.getDataTypeManager(sourceArchive);
        if (sourceDTM == null) {
            Msg.showInfo(((Object)((Object)this)).getClass(), (Component)gTree, (String)"Revert Failed", (Object)("Source Archive not open: " + sourceArchive.getName()));
            return;
        }
        this.plugin.revert(dataType);
        DataTypeSynchronizer synchronizer = new DataTypeSynchronizer(handler, dtm, sourceArchive);
        synchronizer.reSyncOutOfSyncInTimeOnlyDataTypes();
    }
}

