/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.tree;

import ghidra.app.plugin.core.datamgr.tree.DtTypeFilter;
import ghidra.app.plugin.core.datamgr.util.DataTypeUtils;
import ghidra.framework.options.SaveState;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.BuiltInDataTypeManager;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.Union;
import ghidra.program.model.listing.Function;
import java.util.Objects;

public class DtFilterState {
    private static final String XML_NAME = "DATA_TYPES_FILTER";
    private DtTypeFilter arraysFilter = new DtTypeFilter("Arrays");
    private DtTypeFilter enumsFilter = new DtTypeFilter("Enums");
    private DtTypeFilter functionsFilter = new DtTypeFilter("Functions");
    private DtTypeFilter structuresFilter = new DtTypeFilter("Structures");
    private DtTypeFilter pointersFilter = new DtTypeFilter("Pointers");
    private DtTypeFilter unionsFilter = new DtTypeFilter("Unions");

    public DtFilterState() {
        this.arraysFilter.setTypeActive(false);
        this.pointersFilter.setTypeActive(false);
    }

    public DtFilterState copy() {
        DtFilterState filterState = new DtFilterState();
        filterState.arraysFilter = this.arraysFilter.copy();
        filterState.enumsFilter = this.enumsFilter.copy();
        filterState.functionsFilter = this.functionsFilter.copy();
        filterState.structuresFilter = this.structuresFilter.copy();
        filterState.pointersFilter = this.pointersFilter.copy();
        filterState.unionsFilter = this.unionsFilter.copy();
        return filterState;
    }

    public boolean isShowArrays() {
        return this.arraysFilter.isTypeActive();
    }

    public DtTypeFilter getArraysFilter() {
        return this.arraysFilter;
    }

    public void setArraysFilter(DtTypeFilter filter) {
        this.arraysFilter = filter;
    }

    public boolean isShowEnums() {
        return this.enumsFilter.isTypeActive();
    }

    public DtTypeFilter getEnumsFilter() {
        return this.enumsFilter;
    }

    public void setEnumsFilter(DtTypeFilter filter) {
        this.enumsFilter = filter;
    }

    public boolean isShowFunctions() {
        return this.functionsFilter.isTypeActive();
    }

    public DtTypeFilter getFunctionsFilter() {
        return this.functionsFilter;
    }

    public void setFunctionsFilter(DtTypeFilter filter) {
        this.functionsFilter = filter;
    }

    public boolean isShowPointers() {
        return this.pointersFilter.isTypeActive();
    }

    public DtTypeFilter getPointersFilter() {
        return this.pointersFilter;
    }

    public void setPointersFilter(DtTypeFilter filter) {
        this.pointersFilter = filter;
    }

    public boolean isShowStructures() {
        return this.structuresFilter.isTypeActive();
    }

    public DtTypeFilter getStructuresFilter() {
        return this.structuresFilter;
    }

    public void setStructuresFilter(DtTypeFilter filter) {
        this.structuresFilter = filter;
    }

    public boolean isShowUnions() {
        return this.unionsFilter.isTypeActive();
    }

    public DtTypeFilter getUnionsFilter() {
        return this.unionsFilter;
    }

    public void setUnionsFilter(DtTypeFilter filter) {
        this.unionsFilter = filter;
    }

    public boolean passesFilters(DataType dt) {
        DataTypeManager dtm = dt.getDataTypeManager();
        if (dtm instanceof BuiltInDataTypeManager) {
            return true;
        }
        DataType baseDt = DataTypeUtils.getBaseDataType(dt);
        if (dt instanceof Array) {
            return this.passes(this.arraysFilter, dt);
        }
        if (dt instanceof Pointer) {
            return this.passes(this.pointersFilter, dt);
        }
        if (baseDt instanceof Enum) {
            return this.passes(this.enumsFilter, dt);
        }
        if (baseDt instanceof Function) {
            return this.passes(this.functionsFilter, dt);
        }
        if (baseDt instanceof Structure) {
            return this.passes(this.structuresFilter, dt);
        }
        if (baseDt instanceof Union) {
            return this.passes(this.unionsFilter, dt);
        }
        return true;
    }

    private boolean passes(DtTypeFilter filter, DataType dt) {
        if (dt instanceof TypeDef) {
            return filter.isTypeDefActive();
        }
        return filter.isTypeActive();
    }

    public void save(SaveState parentSaveState) {
        SaveState ss = new SaveState(XML_NAME);
        ss.putSaveState(this.arraysFilter.getName(), this.arraysFilter.save());
        ss.putSaveState(this.enumsFilter.getName(), this.enumsFilter.save());
        ss.putSaveState(this.functionsFilter.getName(), this.functionsFilter.save());
        ss.putSaveState(this.pointersFilter.getName(), this.pointersFilter.save());
        ss.putSaveState(this.structuresFilter.getName(), this.structuresFilter.save());
        ss.putSaveState(this.unionsFilter.getName(), this.unionsFilter.save());
        parentSaveState.putSaveState(XML_NAME, ss);
    }

    public void restore(SaveState parentSaveState) {
        SaveState ss = parentSaveState.getSaveState(XML_NAME);
        if (ss == null) {
            return;
        }
        this.arraysFilter = DtTypeFilter.restore("Arrays", ss.getSaveState("Arrays"));
        this.enumsFilter = DtTypeFilter.restore("Enums", ss.getSaveState("Enums"));
        this.functionsFilter = DtTypeFilter.restore("Functions", ss.getSaveState("Functions"));
        this.pointersFilter = DtTypeFilter.restore("Pointers", ss.getSaveState("Pointers"));
        this.structuresFilter = DtTypeFilter.restore("Structures", ss.getSaveState("Structures"));
        this.unionsFilter = DtTypeFilter.restore("Unions", ss.getSaveState("Unions"));
    }

    public int hashCode() {
        return Objects.hash(this.arraysFilter, this.enumsFilter, this.functionsFilter, this.pointersFilter, this.structuresFilter, this.unionsFilter);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DtFilterState other = (DtFilterState)obj;
        return Objects.equals(this.arraysFilter, other.arraysFilter) && Objects.equals(this.enumsFilter, other.enumsFilter) && Objects.equals(this.functionsFilter, other.functionsFilter) && Objects.equals(this.pointersFilter, other.pointersFilter) && Objects.equals(this.structuresFilter, other.structuresFilter) && Objects.equals(this.unionsFilter, other.unionsFilter);
    }
}

