/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin;

import ghidra.app.util.bin.ByteProvider;
import ghidra.formats.gfilesystem.FSRL;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class EmptyByteProvider
implements ByteProvider {
    private final FSRL fsrl;

    public EmptyByteProvider() {
        this(null);
    }

    public EmptyByteProvider(FSRL fsrl) {
        this.fsrl = fsrl;
    }

    @Override
    public FSRL getFSRL() {
        return this.fsrl;
    }

    @Override
    public File getFile() {
        return null;
    }

    @Override
    public String getName() {
        return this.fsrl != null ? this.fsrl.getName() : null;
    }

    @Override
    public String getAbsolutePath() {
        return this.fsrl != null ? this.fsrl.getPath() : null;
    }

    @Override
    public byte readByte(long index) throws IOException {
        throw new IOException("Not supported");
    }

    @Override
    public byte[] readBytes(long index, long length) throws IOException {
        if (index != 0L || length != 0L) {
            throw new IOException("Not supported");
        }
        return new byte[0];
    }

    @Override
    public long length() {
        return 0L;
    }

    @Override
    public boolean isEmpty() {
        return true;
    }

    @Override
    public boolean isValidIndex(long index) {
        return false;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public InputStream getInputStream(long index) throws IOException {
        if (index != 0L) {
            throw new IOException("Invalid offset");
        }
        return InputStream.nullInputStream();
    }
}

