/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.elf.relocation;

import ghidra.app.util.MemoryBlockUtils;
import ghidra.app.util.bin.format.elf.ElfLoadHelper;
import ghidra.app.util.bin.format.elf.ElfRelocation;
import ghidra.app.util.bin.format.elf.ElfRelocationTable;
import ghidra.app.util.bin.format.elf.ElfSymbol;
import ghidra.app.util.bin.format.elf.ElfSymbolTable;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationContext;
import ghidra.app.util.bin.format.elf.relocation.ElfRelocationHandler;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.model.mem.MemoryBlock;
import ghidra.util.BigEndianDataConverter;
import ghidra.util.LittleEndianDataConverter;
import ghidra.util.Msg;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.exception.NotFoundException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public abstract class ElfGotRelocationContext<H extends ElfRelocationHandler>
extends ElfRelocationContext<H> {
    private AddressRange allocatedGotLimits;
    private Address allocatedGotAddress;
    private Address lastAllocatedGotEntryAddress;
    private Address nextAllocatedGotEntryAddress;
    private Map<Long, Address> gotMap;

    ElfGotRelocationContext(H handler, ElfLoadHelper loadHelper, Map<ElfSymbol, Address> symbolMap) {
        super(handler, loadHelper, symbolMap);
    }

    @Override
    public long getSymbolValue(ElfSymbol symbol) {
        long symbolValue = super.getSymbolValue(symbol);
        if (symbolValue == 0L && "_GLOBAL_OFFSET_TABLE_".equals(symbol.getNameAsString())) {
            Address gotAddr = (Address)this.symbolMap.get(symbol);
            if (gotAddr == null) {
                gotAddr = this.allocateGot();
            }
            if (gotAddr != null) {
                return gotAddr.getOffset();
            }
        }
        return symbolValue;
    }

    @Override
    public long getGOTValue() throws NotFoundException {
        try {
            return super.getGOTValue();
        }
        catch (NotFoundException e) {
            Address gotAddr = this.allocateGot();
            if (gotAddr != null) {
                return gotAddr.getOffset();
            }
            throw e;
        }
    }

    private ElfSymbol findGotElfSymbol() {
        for (ElfSymbolTable st : this.getElfHeader().getSymbolTables()) {
            for (ElfSymbol s : st.getSymbols()) {
                if (!"_GLOBAL_OFFSET_TABLE_".equals(s.getNameAsString())) continue;
                return s;
            }
        }
        return null;
    }

    private int computeRequiredGotSize() {
        HashSet<Long> uniqueSymbolValues = new HashSet<Long>();
        for (ElfRelocationTable rt : this.getElfHeader().getRelocationTables()) {
            ElfSymbolTable st = rt.getAssociatedSymbolTable();
            if (st == null) continue;
            for (ElfRelocation r : rt.getRelocations()) {
                long symbolValue;
                ElfSymbol elfSymbol;
                int symbolIndex = r.getSymbolIndex();
                if (!this.requiresGotEntry(r) || symbolIndex == 0 || (elfSymbol = st.getSymbol(symbolIndex)) == null || uniqueSymbolValues.add(symbolValue = this.getSymbolValue(elfSymbol))) continue;
                System.out.println("Duplicate sym value 0x" + Long.toHexString(symbolValue) + " for " + elfSymbol.getNameAsString());
            }
        }
        return Math.max(8, uniqueSymbolValues.size() * 8);
    }

    protected abstract boolean requiresGotEntry(ElfRelocation var1);

    private Address allocateGot() {
        if (this.allocatedGotAddress != null) {
            if (this.allocatedGotAddress == Address.NO_ADDRESS) {
                return null;
            }
            return this.allocatedGotAddress;
        }
        this.allocatedGotAddress = Address.NO_ADDRESS;
        this.nextAllocatedGotEntryAddress = Address.NO_ADDRESS;
        ElfSymbol gotElfSymbol = this.findGotElfSymbol();
        if (gotElfSymbol == null && !this.getElfHeader().isRelocatable()) {
            this.loadHelper.log("GOT allocatiom failed. _GLOBAL_OFFSET_TABLE_ not defined");
            return null;
        }
        if (gotElfSymbol != null && gotElfSymbol.getValue() != 0L) {
            this.loadHelper.log("GOT allocatiom failed. _GLOBAL_OFFSET_TABLE_ already defined");
            return null;
        }
        int alignment = this.getLoadAdapter().getLinkageBlockAlignment();
        int gotSize = this.computeRequiredGotSize();
        this.allocatedGotLimits = this.getLoadHelper().allocateLinkageBlock(alignment, gotSize, "%got");
        if (this.allocatedGotLimits != null && this.allocatedGotLimits.getMinAddress().getOffset() < Integer.MAX_VALUE) {
            if (gotElfSymbol != null) {
                try {
                    this.loadHelper.createSymbol(this.allocatedGotLimits.getMinAddress(), "_GLOBAL_OFFSET_TABLE_", true, false, null);
                }
                catch (InvalidInputException e) {
                    throw new AssertionError("Unexpected exception", e);
                }
                this.symbolMap.put(gotElfSymbol, this.allocatedGotLimits.getMinAddress());
            }
            this.nextAllocatedGotEntryAddress = this.allocatedGotAddress = this.allocatedGotLimits.getMinAddress();
            this.gotMap = new HashMap<Long, Address>();
            this.loadHelper.log("Created %got block required for GOT relocation processing");
            return this.allocatedGotAddress;
        }
        this.loadHelper.log("Failed to allocate GOT block required for relocation processing");
        return null;
    }

    private Address getNextAllocatedGotEntryAddress() {
        if (this.nextAllocatedGotEntryAddress == null && this.allocateGot() == null) {
            return Address.NO_ADDRESS;
        }
        Address addr = this.nextAllocatedGotEntryAddress;
        if (addr == Address.NO_ADDRESS) {
            return Address.NO_ADDRESS;
        }
        try {
            int pointerSize = this.loadHelper.getProgram().getDefaultPointerSize();
            Address lastAddr = this.nextAllocatedGotEntryAddress.addNoWrap((long)(pointerSize - 1));
            if (this.allocatedGotLimits.contains(lastAddr)) {
                this.lastAllocatedGotEntryAddress = lastAddr;
                this.nextAllocatedGotEntryAddress = this.lastAllocatedGotEntryAddress.addNoWrap(1L);
                if (!this.allocatedGotLimits.contains(this.nextAllocatedGotEntryAddress)) {
                    this.nextAllocatedGotEntryAddress = Address.NO_ADDRESS;
                }
                return addr;
            }
        }
        catch (AddressOverflowException addressOverflowException) {
            // empty catch block
        }
        this.nextAllocatedGotEntryAddress = Address.NO_ADDRESS;
        return Address.NO_ADDRESS;
    }

    public Address getGotEntryAddress(ElfSymbol elfSymbol) {
        long symbolValue = this.getSymbolValue(elfSymbol);
        Address addr = null;
        if (this.gotMap != null) {
            addr = this.gotMap.get(symbolValue);
        }
        if (addr == null) {
            addr = this.getNextAllocatedGotEntryAddress();
            if (this.gotMap != null) {
                this.gotMap.put(symbolValue, addr);
            }
        }
        return addr == Address.NO_ADDRESS ? null : addr;
    }

    private void createGot() {
        if (this.lastAllocatedGotEntryAddress == null) {
            return;
        }
        int size = (int)this.lastAllocatedGotEntryAddress.subtract(this.allocatedGotAddress) + 1;
        try {
            MemoryBlock block = MemoryBlockUtils.createInitializedBlock(this.program, false, "%got", this.allocatedGotAddress, size, "NOTE: This block is artificial and allows ELF Relocations to work correctly", "Elf Loader", true, false, false, this.loadHelper.getLog());
            block.setArtificial(true);
            BigEndianDataConverter converter = this.program.getMemory().isBigEndian() ? BigEndianDataConverter.INSTANCE : LittleEndianDataConverter.INSTANCE;
            for (long symbolValue : this.gotMap.keySet()) {
                Address addr = this.gotMap.get(symbolValue);
                byte[] bytes = converter.getBytes(symbolValue);
                block.putBytes(addr, bytes);
                this.loadHelper.createData(addr, (DataType)PointerDataType.dataType);
            }
        }
        catch (MemoryAccessException e) {
            String msg = "Failed to create GOT at " + String.valueOf(this.allocatedGotAddress);
            this.loadHelper.log(msg);
            Msg.error((Object)this, (Object)msg, (Throwable)e);
        }
    }

    @Override
    public void dispose() {
        this.createGot();
        super.dispose();
    }
}

