/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.omf.omf51;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.omf.OmfString;
import ghidra.app.util.bin.format.omf.OmfUtils;
import java.io.IOException;

public class Omf51ExternalDef {
    public static final int ID_BLOCK_SEGMENT = 0;
    public static final int ID_BLOCK_RELOCATABLE = 1;
    public static final int ID_BLOCK_EXTERNAL = 2;
    private byte blockType;
    private int extId;
    private byte info;
    private OmfString name;

    public Omf51ExternalDef(BinaryReader reader, boolean largeSegmentId) throws IOException {
        this.blockType = reader.readNextByte();
        this.extId = largeSegmentId ? reader.readNextUnsignedShort() : reader.readNextUnsignedByte();
        this.info = reader.readNextByte();
        reader.readNextByte();
        this.name = OmfUtils.readString(reader);
    }

    public byte getBlockType() {
        return this.blockType;
    }

    public int getExtId() {
        return this.extId;
    }

    public byte getInfo() {
        return this.info;
    }

    public OmfString getName() {
        return this.name;
    }

    public int getUsageType() {
        return this.info & 7;
    }

    public boolean isVariable() {
        return (this.info & 0x40) != 0;
    }

    public boolean isFixedReg() {
        return (this.info & 0x20) != 0;
    }

    public int getRegBank() {
        return (this.info & 0x18) >> 7;
    }
}

