/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.omf.omf51;

import ghidra.app.util.bin.format.omf.OmfException;
import ghidra.app.util.bin.format.omf.OmfRecord;
import ghidra.app.util.bin.format.omf.OmfString;
import ghidra.app.util.bin.format.omf.omf51.Omf51LibraryHeaderRecord;
import ghidra.app.util.bin.format.omf.omf51.Omf51LibraryModuleLocation;
import ghidra.app.util.bin.format.omf.omf51.Omf51LibraryModuleLocationsRecord;
import ghidra.app.util.bin.format.omf.omf51.Omf51LibraryModuleNamesRecord;
import ghidra.app.util.bin.format.omf.omf51.Omf51RecordFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class Omf51Library {
    private List<MemberHeader> members = new ArrayList<MemberHeader>();

    public Omf51Library(Omf51RecordFactory factory) throws OmfException, IOException {
        OmfRecord omfRecord = factory.readNextRecord();
        if (!(omfRecord instanceof Omf51LibraryHeaderRecord)) {
            throw new OmfException("Unable to read library header record");
        }
        Omf51LibraryHeaderRecord libraryHeader = (Omf51LibraryHeaderRecord)omfRecord;
        factory.getReader().setPointerIndex(libraryHeader.getModNamesOffset());
        OmfRecord omfRecord2 = factory.readNextRecord();
        if (!(omfRecord2 instanceof Omf51LibraryModuleNamesRecord)) {
            throw new OmfException("Unable to read library module names record");
        }
        Omf51LibraryModuleNamesRecord modNamesRecord = (Omf51LibraryModuleNamesRecord)omfRecord2;
        OmfRecord omfRecord3 = factory.readNextRecord();
        if (!(omfRecord3 instanceof Omf51LibraryModuleLocationsRecord)) {
            throw new OmfException("Unable to read library module locations record");
        }
        Omf51LibraryModuleLocationsRecord modLocations = (Omf51LibraryModuleLocationsRecord)omfRecord3;
        List<Omf51LibraryModuleLocation> locations = modLocations.getLocations();
        int index = 0;
        for (OmfString moduleName : modNamesRecord.getNames()) {
            int currentOffset = locations.get(index).getOffset();
            int nextOffset = index + 1 < locations.size() ? locations.get(index + 1).getOffset() : libraryHeader.getModNamesOffset();
            int size = nextOffset - currentOffset;
            this.members.add(new MemberHeader(currentOffset, size, moduleName.str()));
            ++index;
        }
    }

    public List<MemberHeader> getMembers() {
        return this.members;
    }

    public record MemberHeader(long offset, long size, String name) {
    }
}

