/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.debug;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.debug.DebugSymbol;
import java.io.IOException;

class S_OBJNAME
extends DebugSymbol {
    private int signature;
    private byte nameLen;
    private byte[] padding;

    S_OBJNAME(short length, short type, BinaryReader reader, int ptr) throws IOException {
        this.processDebugSymbol(length, type);
        this.signature = reader.readInt(ptr);
        this.nameLen = reader.readByte(ptr += 4);
        this.name = reader.readAsciiString(++ptr, Byte.toUnsignedInt(this.nameLen));
        int sizeOfPadding = 15 + Byte.toUnsignedInt(this.nameLen) + 1;
        this.padding = reader.readByteArray(ptr += Byte.toUnsignedInt(this.nameLen) + 1, sizeOfPadding);
    }

    public int getSignature() {
        return this.signature;
    }

    public byte getNameLen() {
        return this.nameLen;
    }

    public byte[] getPadding() {
        return this.padding;
    }
}

