/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.viewer.field;

import docking.widgets.fieldpanel.field.AttributedString;
import docking.widgets.fieldpanel.field.FieldElement;
import docking.widgets.fieldpanel.field.TextFieldElement;
import docking.widgets.fieldpanel.support.FieldLocation;
import ghidra.app.util.ListingHighlightProvider;
import ghidra.app.util.viewer.field.FieldFactory;
import ghidra.app.util.viewer.field.ListingColors;
import ghidra.app.util.viewer.field.ListingField;
import ghidra.app.util.viewer.field.ListingTextField;
import ghidra.app.util.viewer.format.FieldFormatModel;
import ghidra.app.util.viewer.proxy.ProxyObj;
import ghidra.framework.options.Options;
import ghidra.framework.options.ToolOptions;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Variable;
import ghidra.program.util.AssignedVariableLocation;
import ghidra.program.util.ProgramLocation;
import java.awt.Color;
import java.math.BigInteger;
import java.util.ArrayList;

public class AssignedVariableFieldFactory
extends FieldFactory {
    public static final String FIELD_NAME = "Var Assign";

    public AssignedVariableFieldFactory() {
        super(FIELD_NAME);
    }

    private AssignedVariableFieldFactory(FieldFormatModel model, ListingHighlightProvider hsProvider, Options displayOptions, Options fieldOptions) {
        super(FIELD_NAME, model, hsProvider, displayOptions, fieldOptions);
    }

    @Override
    public ListingField getField(ProxyObj<?> proxy, int varWidth) {
        Object obj = proxy.getObject();
        if (!this.enabled || !(obj instanceof CodeUnit)) {
            return null;
        }
        CodeUnit cu = (CodeUnit)obj;
        ArrayList<FieldElement> elements = new ArrayList<FieldElement>();
        Function f = cu.getProgram().getFunctionManager().getFunctionContaining(cu.getMinAddress());
        if (f != null) {
            Variable[] vars;
            int minOffset = (int)(cu.getMinAddress().getOffset() - f.getEntryPoint().getOffset());
            int maxOffset = minOffset + cu.getLength() - 1;
            for (Variable var : vars = f.getLocalVariables()) {
                int firstUseOffset = var.getFirstUseOffset();
                if (firstUseOffset == 0 || firstUseOffset < minOffset || firstUseOffset > maxOffset) continue;
                StringBuffer buf = new StringBuffer("assign ");
                buf.append(var.getVariableStorage().toString());
                buf.append(" = ");
                buf.append(var.getName());
                AttributedString as = new AttributedString(buf.toString(), (Color)ListingColors.FunctionColors.VARIABLE_ASSIGNED, this.getMetrics());
                elements.add((FieldElement)new TextFieldElement(as, 0, 0));
            }
        }
        if (elements.isEmpty()) {
            return null;
        }
        return ListingTextField.createMultilineTextField(this, proxy, elements, this.startX + varWidth, this.width, this.hlProvider);
    }

    @Override
    public ProgramLocation getProgramLocation(int row, int col, ListingField bf) {
        Object obj = bf.getProxy().getObject();
        if (!(obj instanceof CodeUnit)) {
            return null;
        }
        CodeUnit cu = (CodeUnit)obj;
        return new AssignedVariableLocation(cu.getProgram(), cu.getMinAddress(), row, col);
    }

    @Override
    public FieldLocation getFieldLocation(ListingField bf, BigInteger index, int fieldNum, ProgramLocation programLoc) {
        if (programLoc instanceof AssignedVariableLocation) {
            AssignedVariableLocation loc = (AssignedVariableLocation)programLoc;
            return new FieldLocation(index, fieldNum, loc.getRow(), loc.getCharOffset());
        }
        return null;
    }

    @Override
    public boolean acceptsType(int category, Class<?> proxyObjectClass) {
        if (!CodeUnit.class.isAssignableFrom(proxyObjectClass)) {
            return false;
        }
        return category == 4;
    }

    @Override
    public FieldFactory newInstance(FieldFormatModel formatModel, ListingHighlightProvider hsProvider, ToolOptions displayOptions, ToolOptions fieldOptions) {
        return new AssignedVariableFieldFactory(formatModel, hsProvider, (Options)displayOptions, (Options)fieldOptions);
    }
}

