/*
 * Decompiled with CFR 0.152.
 */
package generic.theme;

import generic.theme.GThemeValueMap;
import generic.theme.IconValue;
import generic.theme.ThemeValueUtils;
import java.awt.Dimension;
import java.awt.Point;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import resources.MultiIcon;
import resources.ResourceManager;
import resources.icons.ReflectedIcon;
import resources.icons.RotateIcon;
import resources.icons.TranslateIcon;

public class IconModifier {
    Dimension size;
    Point translation;
    boolean disabled;
    Integer rotation;
    boolean mirror;
    boolean flip;
    List<IconValue> overlayIconValues = null;

    public IconModifier(Dimension size, Point translation, Integer rotation, boolean disabled, boolean mirror, boolean flip) {
        this.size = size;
        this.translation = translation;
        this.rotation = rotation;
        this.disabled = disabled;
        this.mirror = mirror;
        this.flip = flip;
    }

    private IconModifier() {
    }

    public void setSizeModifier(Dimension size) {
        this.size = size;
    }

    public void setMoveModifier(Point point) {
        this.translation = point;
    }

    public void setRotationModifer(int degrees) {
        this.rotation = degrees;
    }

    public void setDisabled() {
        this.disabled = true;
    }

    public void setMirror() {
        this.mirror = true;
    }

    public void setFlip() {
        this.flip = true;
    }

    public Icon modify(Icon icon, GThemeValueMap values) {
        Icon modified = icon;
        if (this.size != null) {
            modified = ResourceManager.getScaledIcon(modified, this.size.width, this.size.height);
        }
        if (this.disabled) {
            modified = ResourceManager.getDisabledIcon(modified);
        }
        if (this.mirror) {
            modified = new ReflectedIcon(modified, true);
        }
        if (this.flip) {
            modified = new ReflectedIcon(modified, false);
        }
        if (this.rotation != null) {
            modified = new RotateIcon(modified, this.rotation);
        }
        if (this.translation != null) {
            modified = new TranslateIcon(modified, this.translation.x, this.translation.y);
        }
        if (this.overlayIconValues != null) {
            MultiIcon multiIcon = new MultiIcon(modified);
            for (IconValue iconValue : this.overlayIconValues) {
                multiIcon.addIcon(iconValue.get(values));
            }
            modified = multiIcon;
        }
        return modified;
    }

    public String getSerializationString() {
        StringBuilder builder = new StringBuilder();
        if (this.size != null) {
            builder.append("[size(" + this.size.width + "," + this.size.height + ")]");
        }
        if (this.mirror) {
            builder.append("[mirror]");
        }
        if (this.flip) {
            builder.append("[flip]");
        }
        if (this.rotation != null) {
            builder.append("[rotate(" + this.rotation + ")]");
        }
        if (this.translation != null) {
            builder.append("[move(" + this.translation.x + "," + this.translation.y + ")]");
        }
        if (this.disabled) {
            builder.append("[disabled]");
        }
        return builder.toString();
    }

    public static IconModifier parse(String iconModifierString) throws ParseException {
        if (iconModifierString.isBlank()) {
            return null;
        }
        IconModifier modifier = new IconModifier();
        String baseModifierString = IconModifier.getBaseModifierString(iconModifierString);
        IconModifier.parseBaseModifiers(modifier, baseModifierString);
        String overlayValuesString = IconModifier.getIconOverlaysString(iconModifierString);
        IconModifier.parseOverlayModifiers(modifier, overlayValuesString);
        if (modifier.hadModifications()) {
            return modifier;
        }
        return null;
    }

    private static void parseOverlayModifiers(IconModifier modifier, String overlayValuesString) throws ParseException {
        List<String> overlayModifierStrings = ThemeValueUtils.parseGroupings(overlayValuesString, '{', '}');
        for (String overlayIconString : overlayModifierStrings) {
            IconValue overlayIconValue = IconValue.parse("", overlayIconString);
            modifier.addOverlayIcon(overlayIconValue);
        }
    }

    private void addOverlayIcon(IconValue overlayIconValue) {
        if (this.overlayIconValues == null) {
            this.overlayIconValues = new ArrayList<IconValue>();
        }
        this.overlayIconValues.add(overlayIconValue);
    }

    private static void parseBaseModifiers(IconModifier modifier, String baseModifierString) throws ParseException {
        List<String> modifierValues = ThemeValueUtils.parseGroupings(baseModifierString, '[', ']');
        for (String modifierString : modifierValues) {
            if ((modifierString = modifierString.replaceAll("\\s", "").toLowerCase()).startsWith("size")) {
                IconModifier.parseSizeModifier(modifier, modifierString);
                continue;
            }
            if (modifierString.startsWith("move")) {
                IconModifier.parseMoveModifier(modifier, modifierString);
                continue;
            }
            if (modifierString.startsWith("mirror")) {
                IconModifier.parseMirrorModifier(modifier, modifierString);
                continue;
            }
            if (modifierString.startsWith("flip")) {
                IconModifier.parseFlipModifier(modifier, modifierString);
                continue;
            }
            if (modifierString.startsWith("rotate")) {
                IconModifier.parseRotateModifier(modifier, modifierString);
                continue;
            }
            if (modifierString.startsWith("disabled")) {
                IconModifier.parseDisabledModifier(modifier, modifierString);
                continue;
            }
            throw new ParseException("Invalid icon modifier: " + modifierString, 0);
        }
    }

    private static String getBaseModifierString(String value) {
        int overlayStart = value.indexOf("{");
        if (overlayStart < 0) {
            return value;
        }
        if (overlayStart == 0) {
            return "";
        }
        return value.substring(0, overlayStart);
    }

    private static String getIconOverlaysString(String value) {
        int overlayStart = value.indexOf("{");
        if (overlayStart >= 0) {
            return value.substring(overlayStart);
        }
        return "";
    }

    private boolean hadModifications() {
        return this.size != null || this.translation != null || this.overlayIconValues != null || this.rotation != null || this.disabled || this.mirror || this.flip;
    }

    private static void parseDisabledModifier(IconModifier modifier, String modifierString) throws ParseException {
        if (!modifierString.equals("disabled")) {
            throw new ParseException("Illegal Icon modifier: " + String.valueOf(modifier), 0);
        }
        modifier.setDisabled();
    }

    private static void parseMirrorModifier(IconModifier modifier, String modifierString) throws ParseException {
        if (!modifierString.equals("mirror")) {
            throw new ParseException("Illegal Icon modifier: " + String.valueOf(modifier), 0);
        }
        modifier.setMirror();
    }

    private static void parseFlipModifier(IconModifier modifier, String modifierString) throws ParseException {
        if (!modifierString.equals("flip")) {
            throw new ParseException("Illegal Icon modifier: " + String.valueOf(modifier), 0);
        }
        modifier.setFlip();
    }

    private static void parseRotateModifier(IconModifier modifier, String modifierString) throws ParseException {
        String argsString = modifierString.substring("rotate".length());
        int rotation = IconModifier.parseIntArg(argsString);
        modifier.setRotationModifer(rotation);
    }

    private static void parseMoveModifier(IconModifier modifier, String modifierString) throws ParseException {
        String argsString = modifierString.substring("move".length());
        Point argValue = IconModifier.parsePointArgs(argsString);
        modifier.setMoveModifier(argValue);
    }

    private static void parseSizeModifier(IconModifier modifier, String modifierString) throws ParseException {
        String argsString = modifierString.substring("size".length());
        Point argValue = IconModifier.parsePointArgs(argsString);
        modifier.setSizeModifier(new Dimension(argValue.x, argValue.y));
    }

    private static Point parsePointArgs(String argsString) throws ParseException {
        if (!argsString.startsWith("(") || !argsString.endsWith(")")) {
            throw new ParseException("Invalid arguments: " + argsString, 0);
        }
        String[] split = (argsString = argsString.substring(1, argsString.length() - 1)).split(",");
        if (split.length != 2) {
            throw new ParseException("Invalid arguments: " + argsString, 0);
        }
        try {
            int arg1 = Integer.parseInt(split[0]);
            int arg2 = Integer.parseInt(split[1]);
            return new Point(arg1, arg2);
        }
        catch (NumberFormatException e) {
            throw new ParseException("Invalid arguments: " + argsString, 0);
        }
    }

    private static int parseIntArg(String argString) throws ParseException {
        if (!argString.startsWith("(") || !argString.endsWith(")")) {
            throw new ParseException("Invalid arguments: " + argString, 0);
        }
        argString = argString.substring(1, argString.length() - 1);
        try {
            return Integer.parseInt(argString);
        }
        catch (NumberFormatException e) {
            throw new ParseException("Invalid arguments: " + argString, 0);
        }
    }
}

