/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.textfield;

import docking.DockingUtils;
import docking.util.GraphicsUtils;
import generic.theme.GThemeDefaults;
import generic.theme.Gui;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.ToolTipManager;

public class HexDecimalModeTextField
extends JTextField {
    private static final String FONT_ID = "font.input.hint";
    private int hintWidth;
    private boolean isHexMode;
    private boolean showNumbericDecoration = true;

    public HexDecimalModeTextField(int columns, final Consumer<Boolean> modeConsumer) {
        super(columns);
        FontMetrics fontMetrics = this.getFontMetrics(Gui.getFont((String)FONT_ID));
        String mode = this.isHexMode ? "Hex" : "Dec";
        this.hintWidth = fontMetrics.stringWidth(mode);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 77 && DockingUtils.isControlModifier(e)) {
                    HexDecimalModeTextField.this.isHexMode = !HexDecimalModeTextField.this.isHexMode;
                    modeConsumer.accept(HexDecimalModeTextField.this.isHexMode);
                    HexDecimalModeTextField.this.repaint();
                }
            }
        });
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        int hintStart = this.getBounds().width - this.hintWidth;
        if (event.getX() > hintStart) {
            String key = DockingUtils.CONTROL_KEY_NAME;
            return "Press '" + key + "-M' to toggle Hex or Decimal Mode";
        }
        return null;
    }

    public void setHexMode(boolean hexMode) {
        this.isHexMode = hexMode;
    }

    public void setShowNumberMode(boolean show) {
        this.showNumbericDecoration = show;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.showNumbericDecoration) {
            return;
        }
        Font savedFont = g.getFont();
        g.setFont(Gui.getFont((String)FONT_ID));
        g.setColor((Color)GThemeDefaults.Colors.Messages.HINT);
        Dimension size = this.getSize();
        Insets insets = this.getInsets();
        int x = this.getHorizontalAlignment() == 4 ? insets.left : size.width - insets.right - this.hintWidth;
        int y = size.height - insets.bottom - 1;
        String mode = this.isHexMode ? "Hex" : "Dec";
        GraphicsUtils.drawString((JComponent)this, g, mode, x, y);
        g.setFont(savedFont);
    }
}

