/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.tree;

import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.GTreeRestoreTreeStateTask;
import docking.widgets.tree.GTreeState;
import docking.widgets.tree.GTreeTask;
import docking.widgets.tree.support.GTreeFilter;
import docking.widgets.tree.tasks.GTreeClearTreeFilterTask;
import docking.widgets.tree.tasks.GTreeExpandAllTask;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.List;
import java.util.Objects;
import javax.swing.tree.TreePath;

public class GTreeFilterTask
extends GTreeTask {
    private final GTreeFilter filter;
    private volatile boolean cancelledProgramatically;

    public GTreeFilterTask(GTree tree, GTreeFilter filter) {
        super(tree);
        this.filter = filter;
        tree.saveFilterRestoreState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TaskMonitor monitor) {
        if (this.filter == null) {
            this.runOnSwingThread(() -> this.tree.swingRestoreNonFilteredRootNode());
            this.restoreInSameTask(monitor);
            return;
        }
        GTreeNode root = this.tree.getModelRoot();
        try {
            monitor.setMessage("Loading/Organizing Tree ....");
            this.tree.setEventsEnabled(false);
            int nodeCount = root.loadAll(monitor);
            this.tree.setEventsEnabled(true);
            monitor.setMessage("Filtering...");
            monitor.initialize((long)nodeCount);
            GTreeNode filtered = root.filter(this.filter, monitor);
            this.runOnSwingThread(() -> this.tree.swingSetFilteredRootNode(filtered));
            if (this.filter.showFilterMatches()) {
                this.expandInSameTask(monitor, filtered);
                this.restoreInSameTask(monitor);
            }
        }
        catch (CloneNotSupportedException e) {
            Msg.error((Object)((Object)this), (Object)"Got Unexpected CloneNotSupportedException", (Throwable)e);
        }
        catch (CancelledException e) {
            if (!this.cancelledProgramatically) {
                this.tree.runTask(new GTreeClearTreeFilterTask(this.tree));
            }
        }
        finally {
            this.tree.setEventsEnabled(true);
        }
    }

    private void expandInSameTask(TaskMonitor monitor, GTreeNode filtered) {
        GTreeExpandAllTask expandTask = new GTreeExpandAllTask(this.tree, filtered);
        expandTask.run(monitor);
    }

    private void restoreInSameTask(TaskMonitor monitor) {
        GTreeState state = this.tree.getFilterRestoreState();
        if (state == null) {
            return;
        }
        if (this.isOnlyRootSelected(state)) {
            return;
        }
        GTreeRestoreTreeStateTask restoreTask = new GTreeRestoreTreeStateTask(this.tree, state);
        restoreTask.run(monitor);
    }

    private boolean isOnlyRootSelected(GTreeState state) {
        List<TreePath> paths = state.getSelectedPaths();
        if (paths.size() == 1) {
            TreePath path = paths.get(0);
            GTreeNode node = (GTreeNode)path.getLastPathComponent();
            GTreeNode viewRoot = this.tree.getViewRoot();
            return Objects.equals(node, viewRoot);
        }
        return false;
    }

    public void cancel() {
        this.cancelledProgramatically = true;
        super.cancel();
    }
}

