/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.codecompare.functiongraph;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.action.DockingAction;
import ghidra.app.plugin.core.functiongraph.graph.layout.FGLayoutProvider;
import ghidra.app.plugin.core.functiongraph.mvc.FGController;
import ghidra.app.plugin.core.functiongraph.mvc.FGView;
import ghidra.app.plugin.core.functiongraph.mvc.FgEnv;
import ghidra.app.util.viewer.format.FormatManager;
import ghidra.features.base.codecompare.listing.LinearAddressCorrelation;
import ghidra.features.base.codecompare.panel.CodeComparisonView;
import ghidra.features.base.codecompare.panel.ComparisonData;
import ghidra.features.codecompare.functiongraph.FgComparisonContext;
import ghidra.features.codecompare.functiongraph.FgDisplay;
import ghidra.features.codecompare.functiongraph.FgDisplaySynchronizer;
import ghidra.features.codecompare.functiongraph.actions.FgChooseFormatAction;
import ghidra.features.codecompare.functiongraph.actions.FgRelayoutAction;
import ghidra.features.codecompare.functiongraph.actions.FgResetGraphAction;
import ghidra.features.codecompare.functiongraph.actions.FgTogglePopupsAction;
import ghidra.features.codecompare.functiongraph.actions.FgToggleSatelliteAction;
import ghidra.framework.options.SaveState;
import ghidra.framework.options.ToolOptions;
import ghidra.framework.plugintool.PluginTool;
import ghidra.graph.viewer.GraphSatelliteListener;
import ghidra.program.model.correlate.HashedFunctionAddressCorrelation;
import ghidra.program.model.listing.Function;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.program.util.ListingAddressCorrelation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.HelpLocation;
import ghidra.util.datastruct.Duo;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import help.Help;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.swing.JComponent;

public class FunctionGraphCodeComparisonView
extends CodeComparisonView {
    public static final String NAME = "Function Graph View";
    private static final String FORMAT_KEY = "FIELD_FORMAT";
    private static final String SHOW_POPUPS_KEY = "SHOW_POPUPS";
    private static final String SHOW_SATELLITE_KEY = "SHOW_SATELLITE";
    private static final String LAYOUT_NAME = "LAYOUT_NAME";
    private static final String COMPLEX_LAYOUT_NAME = "COMPLEX_LAYOUT_NAME";
    private static final String LAYOUT_CLASS_NAME = "LAYOUT_CLASS_NAME";
    private FgDisplaySynchronizer coordinator;
    private Duo<FgDisplay> displays = new Duo();
    private Duo<Function> functions = new Duo();
    private ListingAddressCorrelation addressCorrelator;
    private boolean displaysLocked;
    private SaveState defaultSaveState;
    private SaveState saveState;
    private List<DockingAction> actions = new ArrayList<DockingAction>();
    private FgTogglePopupsAction showPopupsAction;
    private FgToggleSatelliteAction showSatelliteAction;

    public FunctionGraphCodeComparisonView(String owner, PluginTool tool) {
        super(owner, tool);
        Help.getHelpService().registerHelp((Object)this, new HelpLocation("FunctionComparison", "FunctionGraph_Diff_View"));
        this.displays = this.buildDisplays();
        this.createActions();
        this.installSatelliteListeners();
        this.buildDefaultSaveState();
        this.buildPanel();
        this.setSynchronizedScrolling(true);
    }

    public String getOwner() {
        return this.owner;
    }

    public Duo<FgDisplay> getDisplays() {
        return this.displays;
    }

    public void stateChanged() {
        this.saveShowPopups(this.saveState);
        this.saveShowSatellite(this.saveState);
        this.saveLayout(this.saveState);
        this.saveCustomFormat(this.saveState);
        if (!this.hasStateChanges()) {
            this.saveState.clear();
        }
        this.tool.setConfigChanged(true);
    }

    private void buildDefaultSaveState() {
        SaveState ss = new SaveState();
        this.saveShowPopups(ss);
        this.saveLayout(ss);
        this.saveCustomFormat(ss);
        this.defaultSaveState = ss;
    }

    private void saveShowPopups(SaveState ss) {
        ss.putBoolean(SHOW_POPUPS_KEY, this.showPopupsAction.isSelected());
    }

    private void saveShowSatellite(SaveState ss) {
        ss.putBoolean(SHOW_SATELLITE_KEY, this.showSatelliteAction.isSelected());
    }

    private void loadShowPopups(SaveState ss) {
        boolean savedShowPopups;
        FgDisplay leftDisplay = (FgDisplay)this.displays.get(Duo.Side.LEFT);
        FGController leftController = leftDisplay.getController();
        boolean currentShowPopups = leftController.arePopupsVisible();
        if (currentShowPopups == (savedShowPopups = ss.getBoolean(SHOW_POPUPS_KEY, currentShowPopups))) {
            return;
        }
        FgDisplay rightDisplay = (FgDisplay)this.displays.get(Duo.Side.RIGHT);
        FGController rightController = rightDisplay.getController();
        leftController.setPopupsVisible(savedShowPopups);
        rightController.setPopupsVisible(savedShowPopups);
        this.showPopupsAction.setSelected(savedShowPopups);
    }

    private void loadShowSatellite(SaveState ss) {
        boolean savedShowSatellite;
        FgDisplay leftDisplay = (FgDisplay)this.displays.get(Duo.Side.LEFT);
        FGController leftController = leftDisplay.getController();
        boolean currentShowSatellite = leftController.isSatelliteVisible();
        if (currentShowSatellite == (savedShowSatellite = ss.getBoolean(SHOW_SATELLITE_KEY, currentShowSatellite))) {
            return;
        }
        FgDisplay rightDisplay = (FgDisplay)this.displays.get(Duo.Side.RIGHT);
        FGController rightController = rightDisplay.getController();
        leftController.setSatelliteVisible(savedShowSatellite);
        rightController.setSatelliteVisible(savedShowSatellite);
        this.showSatelliteAction.setSelected(savedShowSatellite);
    }

    private void saveLayout(SaveState ss) {
        FgDisplay display = (FgDisplay)this.displays.get(Duo.Side.LEFT);
        FGController controller = display.getController();
        FGLayoutProvider layout = controller.getLayoutProvider();
        SaveState layoutState = new SaveState(COMPLEX_LAYOUT_NAME);
        String layoutName = layout.getLayoutName();
        layoutState.putString(LAYOUT_NAME, layoutName);
        layoutState.putString(LAYOUT_CLASS_NAME, layout.getClass().getName());
        ss.putSaveState(COMPLEX_LAYOUT_NAME, layoutState);
    }

    private void loadLayout(SaveState ss) {
        SaveState layoutState = this.saveState.getSaveState(COMPLEX_LAYOUT_NAME);
        if (layoutState == null) {
            return;
        }
        FgDisplay leftDisplay = (FgDisplay)this.displays.get(Duo.Side.LEFT);
        FGController leftController = leftDisplay.getController();
        FGLayoutProvider layout = leftController.getLayoutProvider();
        String savedLayoutName = layoutState.getString(LAYOUT_NAME, layout.getLayoutName());
        if (layout.getLayoutName().equals(savedLayoutName)) {
            return;
        }
        FgDisplay rightDisplay = (FgDisplay)this.displays.get(Duo.Side.RIGHT);
        FGController rightController = rightDisplay.getController();
        FgEnv env = leftController.getEnv();
        ArrayList layoutProviders = new ArrayList(env.getLayoutProviders());
        for (FGLayoutProvider layoutProvider : layoutProviders) {
            String providerName = layoutProvider.getLayoutName();
            if (!providerName.equals(savedLayoutName)) continue;
            leftController.changeLayout(layoutProvider);
            rightController.changeLayout(layoutProvider);
            break;
        }
    }

    private void saveCustomFormat(SaveState ss) {
        FgDisplay display = (FgDisplay)this.displays.get(Duo.Side.LEFT);
        FGController controller = display.getController();
        FormatManager format = controller.getMinimalFormatManager();
        SaveState formatState = new SaveState();
        format.saveState(formatState);
        ss.putSaveState(FORMAT_KEY, formatState);
    }

    private void loadCustomFormat(SaveState ss) {
        SaveState formatState = ss.getSaveState(FORMAT_KEY);
        if (formatState == null) {
            return;
        }
        ToolOptions displayOptions = this.tool.getOptions("Listing Display");
        ToolOptions fieldOptions = this.tool.getOptions("Listing Fields");
        FgDisplay leftDisplay = (FgDisplay)this.displays.get(Duo.Side.LEFT);
        FGController leftController = leftDisplay.getController();
        FormatManager format = leftController.getMinimalFormatManager();
        SaveState testState = new SaveState();
        format.saveState(testState);
        if (this.equals(testState, formatState)) {
            return;
        }
        FormatManager formatManager = new FormatManager(displayOptions, fieldOptions);
        formatManager.readState(formatState);
        leftController.updateMinimalFormatManager(formatManager);
        FgDisplay rightDisplay = (FgDisplay)this.displays.get(Duo.Side.RIGHT);
        FGController rightController = rightDisplay.getController();
        rightController.updateMinimalFormatManager(formatManager);
    }

    public void setSaveState(SaveState ss) {
        this.saveState = ss;
        if (!this.hasStateChanges()) {
            return;
        }
        this.loadShowPopups(ss);
        this.loadShowSatellite(ss);
        this.loadLayout(ss);
        this.loadCustomFormat(ss);
    }

    private boolean hasStateChanges() {
        if (!this.saveState.isEmpty()) {
            return !this.equals(this.saveState, this.defaultSaveState);
        }
        return false;
    }

    private boolean equals(SaveState state1, SaveState state2) {
        String s1 = state1.toString();
        String s2 = state2.toString();
        return Objects.equals(s1, s2);
    }

    private void createActions() {
        FgDisplay left = (FgDisplay)this.displays.get(Duo.Side.LEFT);
        this.actions.add(new FgResetGraphAction(left));
        FgDisplay right = (FgDisplay)this.displays.get(Duo.Side.RIGHT);
        this.actions.add(new FgResetGraphAction(right));
        this.showPopupsAction = new FgTogglePopupsAction(this);
        FGController controller = left.getController();
        boolean showPopups = controller.arePopupsVisible();
        this.showPopupsAction.setSelected(showPopups);
        this.showSatelliteAction = new FgToggleSatelliteAction(this);
        boolean showSatellite = controller.isSatelliteVisible();
        this.showSatelliteAction.setSelected(showSatellite);
        this.actions.add((DockingAction)this.showSatelliteAction);
        this.actions.add((DockingAction)this.showPopupsAction);
        this.actions.add(new FgRelayoutAction(this));
        this.actions.add(new FgChooseFormatAction(this));
    }

    private void installSatelliteListeners() {
        FgDisplay left = (FgDisplay)this.displays.get(Duo.Side.LEFT);
        FgDisplay right = (FgDisplay)this.displays.get(Duo.Side.RIGHT);
        final FGController leftController = left.getController();
        final FGController rightController = right.getController();
        GraphSatelliteListener listener = new GraphSatelliteListener(){

            public void satelliteVisibilityChanged(boolean docked, boolean visible) {
                if (visible) {
                    leftController.setSatelliteVisible(true);
                    rightController.setSatelliteVisible(true);
                }
                FunctionGraphCodeComparisonView.this.showSatelliteAction.setSelected(visible);
                FunctionGraphCodeComparisonView.this.stateChanged();
            }
        };
        FGView lv = leftController.getView();
        FGView rv = rightController.getView();
        lv.addSatelliteListener(listener);
        rv.addSatelliteListener(listener);
    }

    public List<DockingAction> getActions() {
        List superActions = super.getActions();
        superActions.addAll(0, this.actions);
        return this.actions;
    }

    protected void comparisonDataChanged() {
        this.maybeLoadFunction(Duo.Side.LEFT, ((ComparisonData)this.comparisonData.get(Duo.Side.LEFT)).getFunction());
        this.maybeLoadFunction(Duo.Side.RIGHT, ((ComparisonData)this.comparisonData.get(Duo.Side.RIGHT)).getFunction());
        this.addressCorrelator = this.createCorrelator();
        this.updateCoordinator();
        this.updateActionEnablement();
        this.validate();
    }

    private ListingAddressCorrelation createCorrelator() {
        Function f1 = this.getFunction(Duo.Side.LEFT);
        Function f2 = this.getFunction(Duo.Side.RIGHT);
        if (f1 != null && f2 != null) {
            try {
                return new HashedFunctionAddressCorrelation(f1, f2, TaskMonitor.DUMMY);
            }
            catch (MemoryAccessException | CancelledException throwable) {
                // empty catch block
            }
        }
        if (((ComparisonData)this.comparisonData.get(Duo.Side.LEFT)).isEmpty() || ((ComparisonData)this.comparisonData.get(Duo.Side.RIGHT)).isEmpty()) {
            return null;
        }
        return new LinearAddressCorrelation(this.comparisonData);
    }

    private void updateCoordinator() {
        if (this.coordinator != null) {
            this.coordinator.dispose();
            this.coordinator = null;
        }
        if (this.displaysLocked) {
            this.coordinator = new FgDisplaySynchronizer(this.displays, this.addressCorrelator);
            this.coordinator.sync(this.activeSide);
        }
    }

    private void maybeLoadFunction(Duo.Side side, Function function) {
        if (this.functions.get(side) == function) {
            return;
        }
        this.loadFunction(side, null);
        this.loadFunction(side, function);
    }

    private void loadFunction(Duo.Side side, Function function) {
        if (this.functions.get(side) != function) {
            this.functions = this.functions.with(side, (Object)function);
            ((FgDisplay)this.displays.get(side)).showFunction(function);
        }
    }

    private Duo<FgDisplay> buildDisplays() {
        Consumer<FgDisplay> graphChangedCallback = display -> {
            Duo.Side side = this.getSide((FgDisplay)display);
            this.addMouseAndFocusListeners(side);
        };
        FgDisplay leftDisplay = new FgDisplay(this, l -> this.locationChanged(Duo.Side.LEFT, (ProgramLocation)l), graphChangedCallback);
        FgDisplay rightDisplay = new FgDisplay(this, l -> this.locationChanged(Duo.Side.RIGHT, (ProgramLocation)l), graphChangedCallback);
        return new Duo((Object)leftDisplay, (Object)rightDisplay);
    }

    private Duo.Side getSide(FgDisplay display) {
        FgDisplay leftDisplay = (FgDisplay)this.displays.get(Duo.Side.LEFT);
        if (display == leftDisplay) {
            return Duo.Side.LEFT;
        }
        return Duo.Side.RIGHT;
    }

    private void locationChanged(Duo.Side side, ProgramLocation location) {
        if (this.coordinator != null) {
            this.coordinator.setLocation(side, location);
        }
    }

    public String getName() {
        return NAME;
    }

    public void dispose() {
        this.setSynchronizedScrolling(false);
        this.displays.each(FgDisplay::dispose);
    }

    public FgDisplay getActiveDisplay() {
        return (FgDisplay)this.displays.get(this.activeSide);
    }

    public ActionContext getActionContext(ComponentProvider provider, MouseEvent event) {
        FgDisplay display = this.getActiveDisplay();
        Component component = event != null ? event.getComponent() : display.getComponent();
        boolean isLeft = this.activeSide == Duo.Side.LEFT;
        return new FgComparisonContext(provider, this, display, component, isLeft);
    }

    public void updateActionEnablement() {
    }

    public void setSynchronizedScrolling(boolean synchronize) {
        if (this.coordinator != null) {
            this.coordinator.dispose();
            this.coordinator = null;
        }
        this.displaysLocked = synchronize;
        if (this.displaysLocked) {
            this.coordinator = new FgDisplaySynchronizer(this.displays, this.addressCorrelator);
            this.coordinator.sync(this.activeSide);
        }
    }

    public JComponent getComparisonComponent(Duo.Side side) {
        return ((FgDisplay)this.displays.get(side)).getComponent();
    }

    public boolean isBusy() {
        return ((FgDisplay)this.displays.get(Duo.Side.LEFT)).isBusy() || ((FgDisplay)this.displays.get(Duo.Side.RIGHT)).isBusy();
    }
}

