/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.gen.op;

import ghidra.lifecycle.Unfinished;
import ghidra.pcode.emu.jit.analysis.JitControlFlowModel;
import ghidra.pcode.emu.jit.analysis.JitType;
import ghidra.pcode.emu.jit.gen.JitCodeGenerator;
import ghidra.pcode.emu.jit.gen.op.FloatBinOpGen;
import ghidra.pcode.emu.jit.gen.type.TypeConversions;
import ghidra.pcode.emu.jit.op.JitFloatTestOp;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public interface CompareFloatOpGen<T extends JitFloatTestOp>
extends FloatBinOpGen<T> {
    public int fcmpOpcode();

    public int dcmpOpcode();

    public int condOpcode();

    @Override
    default public JitType generateBinOpRunCode(JitCodeGenerator gen, T op, JitControlFlowModel.JitBlock block, JitType lType, JitType rType, MethodVisitor rv) {
        if (!1.$assertionsDisabled && rType != lType) {
            throw new AssertionError();
        }
        JitType outType = op.type().resolve(gen.getTypeModel().typeOf(op.out()));
        Label lblTrue = new Label();
        Label lblDone = new Label();
        JitType jitType = rType;
        Objects.requireNonNull(jitType);
        JitType jitType2 = jitType;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JitType.FloatJitType.class, JitType.DoubleJitType.class, JitType.MpFloatJitType.class}, (Object)jitType2, n)) {
            case 0: {
                JitType.FloatJitType t = (JitType.FloatJitType)jitType2;
                rv.visitInsn(this.fcmpOpcode());
                break;
            }
            case 1: {
                JitType.DoubleJitType t = (JitType.DoubleJitType)jitType2;
                rv.visitInsn(this.dcmpOpcode());
                break;
            }
            case 2: {
                JitType.MpFloatJitType t = (JitType.MpFloatJitType)jitType2;
                Unfinished.TODO((String)"MpFloat", (Object[])new Object[0]);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        rv.visitJumpInsn(this.condOpcode(), lblTrue);
        TypeConversions.generateLdcFalse(outType, rv);
        rv.visitJumpInsn(167, lblDone);
        rv.visitLabel(lblTrue);
        TypeConversions.generateLdcTrue(outType, rv);
        rv.visitLabel(lblDone);
        return outType;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

