/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.database;

import generic.stl.Pair;
import ghidra.app.plugin.processors.sleigh.SleighException;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.SleighLanguageValidator;
import ghidra.app.plugin.processors.sleigh.SpecExtensionEditor;
import ghidra.framework.options.Options;
import ghidra.framework.store.LockException;
import ghidra.program.database.ProgramDB;
import ghidra.program.database.function.FunctionManagerDB;
import ghidra.program.model.lang.BasicCompilerSpec;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.InjectPayload;
import ghidra.program.model.lang.InjectPayloadCallfixup;
import ghidra.program.model.lang.InjectPayloadCallfixupError;
import ghidra.program.model.lang.InjectPayloadCallother;
import ghidra.program.model.lang.InjectPayloadCallotherError;
import ghidra.program.model.lang.InjectPayloadSleigh;
import ghidra.program.model.lang.PcodeInjectLibrary;
import ghidra.program.model.lang.PrototypeModel;
import ghidra.program.model.lang.PrototypeModelError;
import ghidra.program.model.lang.PrototypeModelMerged;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.FunctionIterator;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import ghidra.xml.XmlParseException;
import ghidra.xml.XmlPullParser;
import ghidra.xml.XmlPullParserFactory;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SpecExtension {
    public static final String SPEC_EXTENSION = "Specification Extensions";
    public static final String FORMAT_VERSION_OPTIONNAME = "FormatVersion";
    public static final String VERSION_COUNTER_OPTIONNAME = "VersionCounter";
    public static final int FORMAT_VERSION = 1;
    private ProgramDB program;
    private SleighLanguageValidator cspecValidator = null;

    public SpecExtension(Program program) {
        if (!(program instanceof ProgramDB)) {
            throw new IllegalArgumentException("only normal program supported");
        }
        this.program = (ProgramDB)program;
    }

    public static Type getExtensionType(String nm, boolean isXML) throws SleighException {
        int pos = 0;
        if (isXML) {
            while (pos + 1 < nm.length() && (nm.charAt(pos) != '<' || nm.charAt(pos + 1) == '?') || nm.charAt(pos + 1) == '!') {
                ++pos;
            }
            ++pos;
        }
        if (nm.length() <= pos) {
            throw new SleighException("Unrecognized extension");
        }
        switch (nm.charAt(pos)) {
            case 'c': {
                if (nm.startsWith(Type.CALL_FIXUP.getTagName(), pos)) {
                    return Type.CALL_FIXUP;
                }
                if (!nm.startsWith(Type.CALLOTHER_FIXUP.getTagName(), pos)) break;
                return Type.CALLOTHER_FIXUP;
            }
            case 'p': {
                if (!nm.startsWith(Type.PROTOTYPE_MODEL.getTagName(), pos)) break;
                return Type.PROTOTYPE_MODEL;
            }
            case 'r': {
                if (!nm.startsWith(Type.MERGE_MODEL.getTagName(), pos)) break;
                return Type.MERGE_MODEL;
            }
        }
        throw new SleighException("Unrecognized extension");
    }

    private static boolean isCompilerProperty(String nm) {
        try {
            SpecExtension.getExtensionType(nm, false);
            return true;
        }
        catch (SleighException ex) {
            return false;
        }
    }

    public static int getVersionCounter(Program program) {
        Options options = program.getOptions(SPEC_EXTENSION);
        return options.getInt(VERSION_COUNTER_OPTIONNAME, 0);
    }

    public static List<Pair<String, String>> getCompilerSpecExtensions(Program program) {
        Options options = program.getOptions(SPEC_EXTENSION);
        List optionNames = options.getOptionNames();
        ArrayList<Pair<String, String>> pairList = new ArrayList<Pair<String, String>>();
        for (String optionName : optionNames) {
            String value;
            if (!SpecExtension.isCompilerProperty(optionName) || (value = options.getString(optionName, null)) == null) continue;
            pairList.add((Pair<String, String>)new Pair((Object)optionName, (Object)value));
        }
        return pairList;
    }

    public static String getCompilerSpecExtension(Program program, Type type, String name) {
        String optionName = type.getOptionName(name);
        Options options = program.getOptions(SPEC_EXTENSION);
        return options.getString(optionName, null);
    }

    public static void checkFormatVersion(Program program) throws VersionException {
        Options options = program.getOptions(SPEC_EXTENSION);
        int formatVersion = options.getInt(FORMAT_VERSION_OPTIONNAME, 0);
        if (formatVersion > 1) {
            throw new VersionException("Program contains spec extensions with newer/unknown format", 2, false);
        }
    }

    public static void registerOptions(Program program) {
        if (!(program instanceof ProgramDB)) {
            Msg.error(SpecExtension.class, (Object)"Can only add extensions on a normal program");
            return;
        }
        if (!SystemUtilities.isInHeadlessMode()) {
            Options options = program.getOptions(SPEC_EXTENSION);
            options.setOptionsHelpLocation(new HelpLocation("DecompilePlugin", "ExtensionOptions"));
            options.registerOptionsEditor(() -> new SpecExtensionEditor((ProgramDB)program));
        }
    }

    public static String getFormalName(String optionName) {
        return optionName.substring(optionName.indexOf(95) + 1);
    }

    public static boolean isValidFormalName(String formalName) {
        if (formalName.length() == 0) {
            return false;
        }
        for (int i = 0; i < formalName.length(); ++i) {
            char c = formalName.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_' || c == '.' || c == '-') continue;
            return false;
        }
        return true;
    }

    private static ErrorHandler getErrorHandler(final String docTitle) {
        ErrorHandler errHandler = new ErrorHandler(){

            @Override
            public void error(SAXParseException exception) throws SAXException {
                throw exception;
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                throw exception;
            }

            @Override
            public void warning(SAXParseException exception) throws SAXException {
                Msg.warn((Object)this, (Object)("Warning parsing '" + docTitle + "'"), (Throwable)exception);
            }
        };
        return errHandler;
    }

    public static Object parseExtension(String optionName, String extension, CompilerSpec cspec, boolean provideDummy) throws SAXException, XmlParseException, SleighException {
        ErrorHandler errHandler = SpecExtension.getErrorHandler("extensions");
        XmlPullParser parser = XmlPullParserFactory.create((String)extension, (String)optionName, (ErrorHandler)errHandler, (boolean)false);
        String elName = parser.peek().getName();
        if (elName.endsWith("prototype")) {
            PrototypeModel model;
            if (parser.peek().getName().equals("resolveprototype")) {
                PrototypeModelMerged mergemodel = new PrototypeModelMerged();
                ArrayList<PrototypeModel> curModels = new ArrayList<PrototypeModel>(cspec.getCallingConventions().length);
                for (PrototypeModel curModel : cspec.getCallingConventions()) {
                    curModels.add(curModel);
                }
                try {
                    mergemodel.restoreXml(parser, curModels);
                    model = mergemodel;
                }
                catch (XmlParseException ex) {
                    if (!provideDummy) {
                        throw ex;
                    }
                    model = new PrototypeModelError(SpecExtension.getFormalName(optionName), cspec.getDefaultCallingConvention());
                }
            } else {
                model = new PrototypeModel();
                try {
                    model.restoreXml(parser, cspec);
                }
                catch (XmlParseException ex) {
                    if (!provideDummy) {
                        throw ex;
                    }
                    model = new PrototypeModelError(SpecExtension.getFormalName(optionName), cspec.getDefaultCallingConvention());
                }
            }
            return model;
        }
        if (elName.equals("callfixup")) {
            String nm = parser.peek().getAttribute("name");
            PcodeInjectLibrary injectLibrary = cspec.getPcodeInjectLibrary();
            InjectPayload payload = injectLibrary.allocateInject(optionName, nm, 1);
            if (!(payload instanceof InjectPayloadSleigh)) {
                throw new XmlParseException("Cannot use attached name: " + nm);
            }
            try {
                payload.restoreXml(parser, (SleighLanguage)cspec.getLanguage());
                injectLibrary.parseInject(payload);
            }
            catch (XmlParseException ex) {
                if (!provideDummy) {
                    throw ex;
                }
                payload = new InjectPayloadCallfixupError(cspec.getLanguage().getAddressFactory(), SpecExtension.getFormalName(optionName));
            }
            catch (SleighException ex) {
                if (!provideDummy) {
                    throw ex;
                }
                payload = new InjectPayloadCallfixupError(cspec.getLanguage().getAddressFactory(), (InjectPayloadCallfixup)payload);
            }
            return payload;
        }
        if (elName.equals("callotherfixup")) {
            String nm = parser.peek().getAttribute("name");
            PcodeInjectLibrary injectLibrary = cspec.getPcodeInjectLibrary();
            InjectPayload payload = injectLibrary.allocateInject(optionName, nm, 2);
            if (!(payload instanceof InjectPayloadSleigh)) {
                throw new XmlParseException("Cannot use attached name: " + nm);
            }
            try {
                payload.restoreXml(parser, (SleighLanguage)cspec.getLanguage());
                injectLibrary.parseInject(payload);
            }
            catch (XmlParseException ex) {
                if (!provideDummy) {
                    throw ex;
                }
                payload = new InjectPayloadCallotherError(cspec.getLanguage().getAddressFactory(), SpecExtension.getFormalName(optionName));
            }
            catch (SleighException ex) {
                payload = new InjectPayloadCallotherError(cspec.getLanguage().getAddressFactory(), (InjectPayloadCallother)payload);
            }
            return payload;
        }
        throw new XmlParseException("Unknown compiler spec extension: " + elName);
    }

    protected static void clearAllExtensions(Program program, TaskMonitor monitor) throws CancelledException {
        Options specOptions = program.getOptions(SPEC_EXTENSION);
        List optionNames = specOptions.getOptionNames();
        for (String name : optionNames) {
            monitor.checkCancelled();
            specOptions.removeOption(name);
        }
    }

    private void checkCallFixup(DocInfo doc) throws SleighException {
        CompilerSpec cspec = this.program.getCompilerSpec();
        PcodeInjectLibrary injectLibrary = cspec.getPcodeInjectLibrary();
        InjectPayload payload = injectLibrary.getPayload(1, doc.formalName);
        if (payload == null) {
            return;
        }
        if (injectLibrary.hasProgramPayload(doc.formalName, 1)) {
            return;
        }
        throw new SleighException("Extension cannot replace callfixup: " + doc.formalName);
    }

    private void checkCallotherFixup(DocInfo doc) throws SleighException {
        CompilerSpec cspec = this.program.getCompilerSpec();
        PcodeInjectLibrary injectLibrary = cspec.getPcodeInjectLibrary();
        if (!injectLibrary.hasUserDefinedOp(doc.formalName)) {
            throw new SleighException("CALLOTHER_FIXUP target does not exist: " + doc.formalName);
        }
        InjectPayload payload = injectLibrary.getPayload(2, doc.formalName);
        if (payload == null) {
            return;
        }
        if (injectLibrary.hasProgramPayload(doc.formalName, 2)) {
            return;
        }
        doc.override = true;
    }

    private void checkPrototype(DocInfo doc) throws SleighException {
        PrototypeModel[] allModels;
        CompilerSpec cspec = this.program.getCompilerSpec();
        for (PrototypeModel model : allModels = cspec.getAllModels()) {
            if (!model.getName().equals(doc.formalName) || model.isProgramExtension()) continue;
            throw new SleighException("Extension cannot replace prototype: " + doc.formalName);
        }
    }

    private void checkExtension(DocInfo doc) throws SleighException {
        switch (doc.type.ordinal()) {
            case 2: {
                this.checkCallFixup(doc);
                break;
            }
            case 3: {
                this.checkCallotherFixup(doc);
                break;
            }
            case 1: {
                this.checkPrototype(doc);
                break;
            }
            case 0: {
                this.checkPrototype(doc);
            }
        }
    }

    public DocInfo testExtensionDocument(String document) throws SleighException, SAXException, XmlParseException {
        DocInfo res = new DocInfo(document);
        if (this.cspecValidator == null) {
            this.cspecValidator = new SleighLanguageValidator(4);
        }
        this.cspecValidator.verify(res.optionName, document);
        this.checkExtension(res);
        if (!(this.program.getCompilerSpec() instanceof BasicCompilerSpec)) {
            throw new SleighException("Can only test specification extensions against SLEIGH program");
        }
        BasicCompilerSpec cSpecCopy = new BasicCompilerSpec((BasicCompilerSpec)this.program.getCompilerSpec());
        SpecExtension.parseExtension(res.optionName, document, cSpecCopy, false);
        return res;
    }

    private void removeCallFixup(String fixupName, TaskMonitor monitor) throws CancelledException {
        FunctionManagerDB manager = this.program.getFunctionManager();
        monitor.setMessage("Searching for references to " + fixupName);
        monitor.setMaximum((long)manager.getFunctionCount());
        FunctionIterator iter = manager.getFunctions(true);
        for (int i = 0; i < 2; ++i) {
            while (iter.hasNext()) {
                monitor.checkCancelled();
                monitor.incrementProgress(1L);
                Function function = (Function)iter.next();
                String currentFixup = function.getCallFixup();
                if (currentFixup == null || !currentFixup.equals(fixupName)) continue;
                function.setCallFixup(null);
            }
            if (i == 1) break;
            iter = manager.getExternalFunctions();
        }
    }

    private void removeCallotherFixup(String fixupName, TaskMonitor monitor) {
    }

    private void clearPrototypeEvaluationModel(CompilerSpec.EvaluationModelType modelType, String modelName) {
        CompilerSpec compilerSpec = this.program.getCompilerSpec();
        PrototypeModel evalModel = compilerSpec.getPrototypeEvaluationModel(modelType);
        if (!evalModel.getName().equals(modelName)) {
            return;
        }
        String newName = compilerSpec.getDefaultCallingConvention().getName();
        Options options = this.program.getOptions("Decompiler");
        options.setString("Prototype Evaluation", newName);
    }

    private void removePrototype(String modelName, TaskMonitor monitor) throws CancelledException {
        FunctionManagerDB manager = this.program.getFunctionManager();
        monitor.setMessage("Searching for references to " + modelName);
        monitor.setMaximum((long)manager.getFunctionCount());
        FunctionIterator iter = manager.getFunctions(true);
        for (int i = 0; i < 2; ++i) {
            while (iter.hasNext()) {
                monitor.checkCancelled();
                monitor.incrementProgress(1L);
                Function function = (Function)iter.next();
                PrototypeModel currentModel = function.getCallingConvention();
                if (currentModel == null || !currentModel.getName().equals(modelName)) continue;
                try {
                    function.setCallingConvention("unknown");
                }
                catch (InvalidInputException invalidInputException) {}
            }
            if (i == 1) break;
            iter = manager.getExternalFunctions();
        }
        this.clearPrototypeEvaluationModel(CompilerSpec.EvaluationModelType.EVAL_CURRENT, modelName);
    }

    public void addReplaceCompilerSpecExtension(String document, TaskMonitor monitor) throws LockException, SleighException, SAXException, XmlParseException {
        this.program.checkExclusiveAccess();
        monitor.setMessage("Testing validity of new document");
        DocInfo info = this.testExtensionDocument(document);
        monitor.setMessage("Installing " + info.getFormalName());
        Options specOptions = this.program.getOptions(SPEC_EXTENSION);
        int progVersion = specOptions.getInt(VERSION_COUNTER_OPTIONNAME, 0);
        progVersion = (progVersion + 1) % 0x40000000;
        specOptions.setString(info.getOptionName(), document);
        specOptions.setInt(VERSION_COUNTER_OPTIONNAME, progVersion);
        specOptions.setInt(FORMAT_VERSION_OPTIONNAME, 1);
        this.program.installExtensions();
    }

    public void removeCompilerSpecExtension(String optionName, TaskMonitor monitor) throws LockException, CancelledException {
        this.program.checkExclusiveAccess();
        Type type = SpecExtension.getExtensionType(optionName, false);
        Options specOptions = this.program.getOptions(SPEC_EXTENSION);
        if (!specOptions.contains(optionName)) {
            throw new SleighException("Extension does not exist: " + optionName);
        }
        int progVersion = specOptions.getInt(VERSION_COUNTER_OPTIONNAME, 0);
        progVersion = (progVersion + 1) % 0x40000000;
        String extName = SpecExtension.getFormalName(optionName);
        switch (type.ordinal()) {
            case 2: {
                this.removeCallFixup(extName, monitor);
                break;
            }
            case 3: {
                this.removeCallotherFixup(extName, monitor);
                break;
            }
            case 1: {
                this.removePrototype(extName, monitor);
                break;
            }
            case 0: {
                this.removePrototype(extName, monitor);
            }
        }
        specOptions.removeOption(optionName);
        specOptions.setInt(VERSION_COUNTER_OPTIONNAME, progVersion);
        this.program.installExtensions();
    }

    public static enum Type {
        PROTOTYPE_MODEL("prototype"),
        MERGE_MODEL("resolve"),
        CALL_FIXUP("callfixup"),
        CALLOTHER_FIXUP("callotherfixup");

        private String tagName;

        private Type(String nm) {
            this.tagName = nm;
        }

        public String getTagName() {
            return this.tagName;
        }

        public String getOptionName(String formalName) {
            return this.tagName + "_" + formalName;
        }
    }

    public static class DocInfo {
        private Type type;
        private String formalName;
        private String optionName;
        private boolean override;

        private static String generateOptionNameFromDocument(Type type, String document) throws SleighException {
            String tagAttribute = switch (type.ordinal()) {
                case 0, 1, 2 -> "name=\"";
                case 3 -> "targetop=\"";
                default -> throw new SleighException("Unsupported extension type");
            };
            int startPos = document.indexOf(tagAttribute, 0);
            if (startPos < 0) {
                throw new SleighException("Could not find attribute: " + tagAttribute);
            }
            int endPos = document.indexOf(34, startPos += tagAttribute.length());
            if (endPos < 0) {
                throw new SleighException("Bad XML document");
            }
            String formalName = document.substring(startPos, endPos);
            if (!SpecExtension.isValidFormalName(formalName)) {
                throw new SleighException("Name of extension uses invalid characters");
            }
            return type.getOptionName(formalName);
        }

        public DocInfo(String document) {
            this.type = SpecExtension.getExtensionType(document, true);
            this.optionName = DocInfo.generateOptionNameFromDocument(this.type, document);
            this.formalName = SpecExtension.getFormalName(this.optionName);
            this.override = false;
        }

        public final Type getType() {
            return this.type;
        }

        public final String getFormalName() {
            return this.formalName;
        }

        public final String getOptionName() {
            return this.optionName;
        }

        public final boolean isOverride() {
            return this.override;
        }
    }
}

