/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.actions;

import docking.ActionContext;
import docking.DialogComponentProvider;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.action.ToolBarData;
import generic.theme.GIcon;
import ghidra.feature.vt.gui.editors.TagEditorDialog;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.plugin.VTPlugin;
import ghidra.feature.vt.gui.provider.matchtable.VTMatchContext;
import ghidra.util.HelpLocation;
import javax.swing.Icon;

public class EditAllTagsAction
extends DockingAction {
    private static final String MENU_GROUP = "A_VT_Edit_2";
    private static final Icon EDIT_TAG_ICON = new GIcon("icon.version.tracking.action.edit.all.tags");
    private static final String ACTION_NAME = "Edit VTMatch Tags";
    private final VTController controller;

    public EditAllTagsAction(VTController controller) {
        super(ACTION_NAME, VTPlugin.OWNER);
        this.controller = controller;
        this.setDescription("Edit Match Tags");
        this.setToolBarData(new ToolBarData(EDIT_TAG_ICON, MENU_GROUP));
        MenuData menuData = new MenuData(new String[]{"Edit Tags"}, EDIT_TAG_ICON, MENU_GROUP);
        menuData.setMenuSubGroup("3");
        this.setPopupMenuData(menuData);
        this.setEnabled(false);
        this.setHelpLocation(new HelpLocation("VersionTrackingPlugin", "Edit_Tag"));
    }

    public void actionPerformed(ActionContext context) {
        this.editTag();
    }

    public boolean isEnabledForContext(ActionContext context) {
        if (!(context instanceof VTMatchContext)) {
            return false;
        }
        VTMatchContext matchContext = (VTMatchContext)context;
        return matchContext.getSession() != null;
    }

    private void editTag() {
        TagEditorDialog dialog = new TagEditorDialog(this.controller.getSession());
        this.controller.getTool().showDialog((DialogComponentProvider)dialog, this.controller.getParentComponent());
    }
}

