/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query;

import ghidra.features.bsim.query.BSimServerInfo;
import ghidra.features.bsim.query.client.CancelledSQLException;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskBuilder;
import ghidra.util.task.TaskMonitor;
import java.sql.Connection;
import java.sql.SQLException;

public class BSimDBConnectTaskManager {
    private final BSimServerInfo serverInfo;
    private Exception exc = null;
    private boolean isCancelled = false;
    private int count = 0;

    public BSimDBConnectTaskManager(BSimServerInfo serverInfo) {
        this.serverInfo = serverInfo;
    }

    private void clear() {
        this.exc = null;
        this.isCancelled = false;
        this.count = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection(DBConnectionSupplier connectionSupplier) throws SQLException {
        DBConnectTask connectTask = new DBConnectTask(connectionSupplier);
        try {
            TaskBuilder.withTask((Task)connectTask).setTitle("BSim DB Connection...").setCanCancel(false).setHasProgress(false).launchModal();
            BSimDBConnectTaskManager bSimDBConnectTaskManager = this;
            synchronized (bSimDBConnectTaskManager) {
                block18: {
                    Connection c = connectTask.getConnection();
                    if (c == null) break block18;
                    Connection connection = c;
                    return connection;
                }
                if (this.isCancelled) {
                    throw new CancelledSQLException("Password entry was cancelled");
                }
                Exception exception = this.exc;
                if (exception instanceof SQLException) {
                    SQLException e = (SQLException)exception;
                    throw e;
                }
                exception = this.exc;
                if (exception instanceof RuntimeException) {
                    RuntimeException e = (RuntimeException)exception;
                    throw e;
                }
                throw new RuntimeException(this.exc);
            }
        }
        finally {
            BSimDBConnectTaskManager bSimDBConnectTaskManager = this;
            synchronized (bSimDBConnectTaskManager) {
                if (--this.count == 0) {
                    this.clear();
                }
            }
        }
    }

    private class DBConnectTask
    extends Task {
        private Connection c;
        private DBConnectionSupplier connectionSupplier;

        DBConnectTask(DBConnectionSupplier connectionSupplier) {
            super("BSim Connecting to " + String.valueOf(BSimDBConnectTaskManager.this.serverInfo), false, false, true);
            this.connectionSupplier = connectionSupplier;
        }

        Connection getConnection() {
            return this.c;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(TaskMonitor monitor) throws CancelledException {
            BSimDBConnectTaskManager bSimDBConnectTaskManager = BSimDBConnectTaskManager.this;
            synchronized (bSimDBConnectTaskManager) {
                monitor.setMessage("Connecting...");
                ++BSimDBConnectTaskManager.this.count;
                if (BSimDBConnectTaskManager.this.isCancelled) {
                    throw new CancelledException();
                }
                if (BSimDBConnectTaskManager.this.exc != null) {
                    return;
                }
                try {
                    this.c = this.connectionSupplier.get();
                }
                catch (CancelledException e) {
                    BSimDBConnectTaskManager.this.isCancelled = true;
                    throw e;
                }
                catch (Exception e) {
                    BSimDBConnectTaskManager.this.exc = e;
                }
            }
        }
    }

    public static interface DBConnectionSupplier {
        public Connection get() throws CancelledException, SQLException;
    }
}

