/*
 * Decompiled with CFR 0.152.
 */
package ghidra.features.bsim.query.protocol;

import ghidra.features.bsim.query.LSHException;
import ghidra.features.bsim.query.description.DescriptionManager;
import ghidra.features.bsim.query.description.ExecutableRecord;
import ghidra.features.bsim.query.description.FunctionDescription;
import ghidra.util.xml.SpecXmlUtils;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;

public class SimilarityNote
implements Comparable<SimilarityNote> {
    private FunctionDescription func;
    private double sim;
    private double signif;

    public SimilarityNote() {
    }

    public SimilarityNote(FunctionDescription f, double sm, double sf) {
        this.func = f;
        this.sim = sm;
        this.signif = sf;
    }

    public FunctionDescription getFunctionDescription() {
        return this.func;
    }

    public double getSimilarity() {
        return this.sim;
    }

    public double getSignificance() {
        return this.signif;
    }

    public void transfer(DescriptionManager manage, boolean transsig) throws LSHException {
        this.func = manage.transferFunction(this.func, transsig);
    }

    public void setTransfer(SimilarityNote op2, DescriptionManager manage, boolean transsig) throws LSHException {
        this.func = manage.transferFunction(op2.func, transsig);
        this.sim = op2.sim;
        this.signif = op2.signif;
    }

    public void saveXml(Writer write) throws IOException {
        StringBuilder buf = new StringBuilder();
        buf.append("<note");
        SpecXmlUtils.encodeUnsignedIntegerAttribute((StringBuilder)buf, (String)"id", (long)this.func.getExecutableRecord().getXrefIndex());
        SpecXmlUtils.xmlEscapeAttribute((StringBuilder)buf, (String)"name", (String)this.func.getFunctionName());
        SpecXmlUtils.encodeUnsignedIntegerAttribute((StringBuilder)buf, (String)"addr", (long)this.func.getAddress());
        buf.append(">\n");
        buf.append(" <sim>").append(Double.toString(this.sim)).append("</sim>\n");
        buf.append(" <sig>").append(Double.toString(this.signif)).append("</sig>\n");
        buf.append("</note>\n");
        write.append(buf.toString());
    }

    public void restoreXml(XmlPullParser parser, DescriptionManager manage, Map<Integer, ExecutableRecord> exeMap) throws LSHException {
        XmlElement el = parser.start(new String[]{"note"});
        int id = SpecXmlUtils.decodeInt((String)el.getAttribute("id"));
        ExecutableRecord exe = exeMap.get(id);
        long address = SpecXmlUtils.decodeLong((String)el.getAttribute("addr"));
        this.func = manage.findFunction(el.getAttribute("name"), address, exe);
        parser.start(new String[]{"sim"});
        this.sim = Double.parseDouble(parser.end().getText());
        parser.start(new String[]{"sig"});
        this.signif = Double.parseDouble(parser.end().getText());
        parser.end();
    }

    @Override
    public int compareTo(SimilarityNote o) {
        return this.func.compareTo(o.func);
    }
}

