/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.programtree;

import ghidra.app.cmd.module.RenameCmd;
import ghidra.app.plugin.core.programtree.ProgramDnDTree;
import ghidra.app.plugin.core.programtree.ProgramNode;
import ghidra.framework.cmd.Command;
import ghidra.framework.model.DomainObject;
import ghidra.program.model.listing.Group;
import ghidra.program.model.listing.ProgramModule;
import ghidra.util.Msg;
import ghidra.util.SystemUtilities;
import ghidra.util.datastruct.StringKeyIndexer;
import java.awt.Component;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;

class ProgramTreeModelListener
implements TreeModelListener {
    private ProgramDnDTree tree;

    ProgramTreeModelListener(ProgramDnDTree tree) {
        this.tree = tree;
    }

    @Override
    public void treeNodesChanged(TreeModelEvent e) {
        String newName;
        ProgramNode node = (ProgramNode)e.getTreePath().getLastPathComponent();
        int[] indices = e.getChildIndices();
        if (indices != null) {
            node = (ProgramNode)node.getChildAt(indices[0]);
        }
        if ((newName = node.getUserObject().toString().trim()).isEmpty()) {
            node.setUserObject(node.getName());
            Msg.showError((Object)this, null, (String)"Rename Failed", (Object)"Please enter a name.");
            SystemUtilities.runSwingLater(() -> this.tree.rename());
            return;
        }
        Group group = node.getGroup();
        String oldName = group.getName();
        if (newName.equals(oldName)) {
            return;
        }
        RenameCmd cmd = new RenameCmd(this.tree.getTreeName(), group instanceof ProgramModule, oldName, newName);
        if (this.tree.getTool().execute((Command)cmd, (DomainObject)this.tree.getProgram())) {
            StringKeyIndexer nameIndexer = this.tree.getNameIndexer();
            nameIndexer.remove(oldName);
            nameIndexer.put(newName);
        } else {
            node.setUserObject(node.getName());
            Msg.showError((Object)this, (Component)this.tree, (String)"Rename Failed", (Object)cmd.getStatusMsg());
            SystemUtilities.runSwingLater(() -> this.tree.rename());
        }
        this.tree.setEditable(false);
    }

    @Override
    public void treeNodesInserted(TreeModelEvent e) {
        Object[] path = e.getPath();
        Object[] me = e.getChildren();
        Object[] childPath = new Object[path.length + 1];
        System.arraycopy(path, 0, childPath, 0, path.length);
        childPath[childPath.length - 1] = me[0];
        ProgramNode node = (ProgramNode)me[0];
        node.setTreePath(new TreePath(childPath));
        this.tree.setGroupPath(node);
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent e) {
    }

    @Override
    public void treeStructureChanged(TreeModelEvent e) {
    }
}

