/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.xml;

import ghidra.docking.settings.FormatSettingsDefinition;
import ghidra.docking.settings.Settings;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.EndianSettingsDefinition;
import ghidra.program.model.data.PaddingSettingsDefinition;
import ghidra.program.model.data.TerminatedSettingsDefinition;
import ghidra.util.xml.XmlAttributes;
import ghidra.util.xml.XmlUtilities;
import ghidra.util.xml.XmlWriter;
import ghidra.xml.XmlElement;

class DisplaySettingsHandler {
    DisplaySettingsHandler() {
    }

    static boolean hasSettings(DataType dt) {
        return false;
    }

    static void writeSettings(XmlWriter writer, Settings settings) {
        XmlAttributes attrs = new XmlAttributes();
        if (FormatSettingsDefinition.DEF.hasValue(settings)) {
            attrs.addAttribute("FORMAT", FormatSettingsDefinition.DEF.getDisplayChoice(settings));
        }
        if (PaddingSettingsDefinition.DEF.hasValue(settings)) {
            attrs.addAttribute("ZERO_PAD", PaddingSettingsDefinition.DEF.isPadded(settings) ? "y" : "n");
        }
        if (EndianSettingsDefinition.DEF.hasValue(settings) && EndianSettingsDefinition.DEF.getChoice(settings) != 0) {
            attrs.addAttribute("ENDIAN", EndianSettingsDefinition.DEF.isBigEndian(settings, null) ? "big" : "little");
        }
        if (TerminatedSettingsDefinition.DEF.hasValue(settings)) {
            attrs.addAttribute("SHOW_TERMINATOR", TerminatedSettingsDefinition.DEF.isTerminated(settings) ? "y" : "n");
        }
        if (!attrs.isEmpty()) {
            writer.writeElement("DISPLAY_SETTINGS", attrs);
        }
    }

    static void readSettings(XmlElement element, Settings settings) {
        if (element.hasAttribute("FORMAT")) {
            String format = element.getAttribute("FORMAT");
            FormatSettingsDefinition.DEF.setDisplayChoice(settings, format);
        }
        if (element.hasAttribute("ZERO_PAD")) {
            boolean isPad = XmlUtilities.parseBoolean((String)element.getAttribute("ZERO_PAD"));
            PaddingSettingsDefinition.DEF.setPadded(settings, isPad);
        }
        if (element.hasAttribute("ENDIAN")) {
            String endian = element.getAttribute("ENDIAN");
            EndianSettingsDefinition.DEF.setBigEndian(settings, endian.equals("big"));
        }
        if (element.hasAttribute("SHOW_TERMINATOR")) {
            boolean showTerminator = XmlUtilities.parseBoolean((String)element.getAttribute("SHOW_TERMINATOR"));
            TerminatedSettingsDefinition.DEF.setTerminated(settings, showTerminator);
        }
    }
}

