/*
 * Decompiled with CFR 0.152.
 */
package ghidra.plugins.importer.batch;

import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.opinion.LoadSpec;
import ghidra.app.util.opinion.Loader;
import ghidra.formats.gfilesystem.FSRL;
import ghidra.plugins.importer.batch.BatchGroupLoadSpec;
import ghidra.plugins.importer.batch.BatchSegregatingCriteria;
import ghidra.plugins.importer.batch.UserAddedSourceInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class BatchGroup {
    private final BatchSegregatingCriteria criteria;
    private List<BatchLoadConfig> batchLoadConfigs = new ArrayList<BatchLoadConfig>();
    private BatchGroupLoadSpec selectedBatchGroupLoadSpec;
    private boolean enabled;

    public BatchGroup(BatchSegregatingCriteria criteria) {
        this.criteria = criteria;
        this.selectedBatchGroupLoadSpec = criteria.getFirstPreferredLoadSpec();
        this.enabled = this.selectedBatchGroupLoadSpec != null;
    }

    public void add(ByteProvider provider, Collection<LoadSpec> loadSpecs, FSRL fsrl, UserAddedSourceInfo uasi) {
        this.batchLoadConfigs.add(new BatchLoadConfig(provider, loadSpecs, fsrl, uasi));
    }

    public BatchGroupLoadSpec getSelectedBatchGroupLoadSpec() {
        return this.selectedBatchGroupLoadSpec;
    }

    public void setSelectedBatchGroupLoadSpec(BatchGroupLoadSpec selectedBatchGroupLoadSpec) {
        this.selectedBatchGroupLoadSpec = selectedBatchGroupLoadSpec;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public BatchSegregatingCriteria getCriteria() {
        return this.criteria;
    }

    public int size() {
        return this.batchLoadConfigs.size();
    }

    public boolean isEmpty() {
        return this.batchLoadConfigs.size() == 0;
    }

    public List<BatchLoadConfig> getBatchLoadConfig() {
        return this.batchLoadConfigs;
    }

    public void removeDescendantsOf(FSRL fsrl) {
        Iterator<BatchLoadConfig> iterator = this.batchLoadConfigs.iterator();
        while (iterator.hasNext()) {
            BatchLoadConfig ai = iterator.next();
            if (!ai.fsrl.isEquivalent(fsrl) && !ai.fsrl.isDescendantOf(fsrl)) continue;
            iterator.remove();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.criteria.toString()).append(" ->\n");
        for (BatchLoadConfig batchLoadConfig : this.batchLoadConfigs) {
            sb.append("    ").append(batchLoadConfig.preferredFileName).append("\n");
        }
        return sb.toString();
    }

    public static class BatchLoadConfig {
        private Collection<LoadSpec> loadSpecs;
        private FSRL fsrl;
        private UserAddedSourceInfo uasi;
        private Loader loader;
        private String preferredFileName;

        BatchLoadConfig(ByteProvider provider, Collection<LoadSpec> loadSpecs, FSRL fsrl, UserAddedSourceInfo uasi) {
            this.loadSpecs = loadSpecs;
            this.fsrl = fsrl;
            this.uasi = uasi;
            this.loader = loadSpecs.iterator().next().getLoader();
            this.preferredFileName = this.loader.getPreferredFileName(provider);
        }

        public Collection<LoadSpec> getLoadSpecs() {
            return this.loadSpecs;
        }

        public FSRL getFSRL() {
            return this.fsrl;
        }

        public LoadSpec getLoadSpec(BatchGroupLoadSpec batchGroupLoadSpec) {
            for (LoadSpec loadSpec : this.loadSpecs) {
                if (!batchGroupLoadSpec.matches(loadSpec)) continue;
                return loadSpec;
            }
            return null;
        }

        public UserAddedSourceInfo getUasi() {
            return this.uasi;
        }

        public Loader getLoader() {
            return this.loader;
        }

        public String getPreferredFileName() {
            return this.preferredFileName;
        }
    }
}

