/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.listing;

import ghidra.docking.settings.Settings;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.lang.Language;
import ghidra.program.model.listing.Data;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.data.DBTraceDataSettingsOperations;
import ghidra.trace.database.listing.DBTraceDataAdapter;
import ghidra.trace.database.memory.DBTraceMemorySpace;
import ghidra.trace.model.ImmutableTraceAddressSnapRange;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.listing.TraceData;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.TraceSpaceMixin;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;

public class UndefinedDBTraceData
implements DBTraceDataAdapter,
TraceSpaceMixin {
    protected final DBTrace trace;
    protected final long snap;
    protected final Lifespan lifespan;
    protected final Address address;
    protected final TraceThread thread;
    protected final int frameLevel;

    public UndefinedDBTraceData(DBTrace trace, long snap, Address address, TraceThread thread, int frameLevel) {
        this.trace = trace;
        this.snap = snap;
        this.lifespan = Lifespan.at(snap);
        this.address = address;
        this.thread = thread;
        this.frameLevel = frameLevel;
    }

    @Override
    public AddressSpace getAddressSpace() {
        return this.address.getAddressSpace();
    }

    @Override
    public void delete() {
        throw new UnsupportedOperationException("Cannot delete an undefined code unit");
    }

    @Override
    public DBTrace getTrace() {
        return this.trace;
    }

    @Override
    public Language getLanguage() {
        return this.trace.getBaseLanguage();
    }

    @Override
    public TracePlatform getPlatform() {
        return this.trace.getPlatformManager().getHostPlatform();
    }

    @Override
    public AddressRange getRange() {
        return new AddressRangeImpl(this.getMinAddress(), this.getMaxAddress());
    }

    @Override
    public TraceAddressSnapRange getBounds() {
        return new ImmutableTraceAddressSnapRange(this.getMinAddress(), this.getMaxAddress(), this.getLifespan());
    }

    @Override
    public Lifespan getLifespan() {
        return this.lifespan;
    }

    @Override
    public long getStartSnap() {
        return this.snap;
    }

    @Override
    public void setEndSnap(long endSnap) {
        throw new UnsupportedOperationException("Cannot modify lifespan of default data unit");
    }

    @Override
    public long getEndSnap() {
        return this.snap;
    }

    public Address getAddress() {
        return this.address;
    }

    @Override
    public TraceThread getThread() {
        return this.thread;
    }

    @Override
    public int getFrameLevel() {
        return this.frameLevel;
    }

    public int getLength() {
        return 1;
    }

    public Address getMaxAddress() {
        return this.address;
    }

    public String toString() {
        return this.doToString();
    }

    @Override
    public Address getAddress(int opIndex) {
        return null;
    }

    @Override
    public int getBytes(ByteBuffer buffer, int addressOffset) {
        DBTraceMemorySpace mem = (DBTraceMemorySpace)this.trace.getMemoryManager().get(this.getAddressSpace(), false);
        if (mem == null) {
            return 0;
        }
        return mem.getBytes(this.getStartSnap(), this.address.add((long)addressOffset), buffer);
    }

    public boolean isDefined() {
        return false;
    }

    public DataType getDataType() {
        return DataType.DEFAULT;
    }

    public DataType getBaseDataType() {
        return DataType.DEFAULT;
    }

    public String getFieldName() {
        return null;
    }

    public String getPathName() {
        return this.getPrimarySymbolOrDynamicName();
    }

    public String getComponentPathName() {
        return null;
    }

    public Data getParent() {
        return null;
    }

    @Override
    public DBTraceDataAdapter getRoot() {
        return this;
    }

    public int getRootOffset() {
        return 0;
    }

    public int getParentOffset() {
        return 0;
    }

    @Override
    public TraceData getComponent(int index) {
        return null;
    }

    @Override
    public TraceData getComponent(int[] componentPath) {
        if (componentPath == null || componentPath.length == 0) {
            return this;
        }
        return null;
    }

    public int[] getComponentPath() {
        return EMPTY_INT_ARRAY;
    }

    public int getNumComponents() {
        return 0;
    }

    @Override
    public TraceData getComponentAt(int offset) {
        return null;
    }

    @Override
    public TraceData getComponentContaining(int offset) {
        return null;
    }

    public List<Data> getComponentsContaining(int offset) {
        if (offset < 0 || offset >= this.getLength()) {
            return null;
        }
        return Collections.emptyList();
    }

    @Override
    public UndefinedDBTraceData getPrimitiveAt(int offset) {
        if (offset < 0 || offset >= this.getLength()) {
            return null;
        }
        return this;
    }

    public int getComponentIndex() {
        return -1;
    }

    public int getComponentLevel() {
        return 0;
    }

    @Override
    public DBTraceDataSettingsOperations getSettingsSpace(boolean createIfAbsent) {
        return (DBTraceDataSettingsOperations)this.getTrace().getDataSettingsAdapter().get(this.getAddressSpace(), createIfAbsent);
    }

    public Settings getDefaultSettings() {
        return DataType.DEFAULT.getDefaultSettings();
    }
}

